/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;

public class ModuleConfigList
extends ContainerObjectSelectionList<Entry> {
    private ModuleConfigScreen screen;

    public ModuleConfigList(ModuleConfigScreen screen, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.screen = screen;
    }

    public void saveAll() {
        for (Entry entry : this.m_6702_()) {
            entry.save();
        }
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        Entry entry = (Entry)this.m_93412_(mouseX, mouseY);
        if (mouseX < this.f_93388_ / 2 && entry != null && !entry.comments.isEmpty()) {
            graphics.m_280677_(this.f_93386_.f_91062_, entry.comments, Optional.empty(), mouseX, mouseY);
        }
    }

    public int m_5759_() {
        return this.f_93388_ - 40;
    }

    protected int m_5756_() {
        return this.f_93388_ - 6;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final ModuleConfigList parent;
        private final List<Component> comments = new ArrayList<Component>();
        private final Component text;
        private final AbstractWidget configButton;
        private final List<AbstractWidget> children;

        public Entry(ModuleConfigList parent, String comments, Component text, AbstractWidget button) {
            this.parent = parent;
            if (!StringUtil.m_14408_((String)comments)) {
                for (String comment : comments.split("\n")) {
                    this.comments.add((Component)Component.m_237113_((String)comment));
                }
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new AbstractWidget[]{this.configButton});
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.m_252865_(left + width / 2 + 10);
            this.configButton.m_253211_(top + (innerHeight - this.configButton.m_93694_()) / 2);
            this.configButton.m_93674_(width / 2 - 10);
            this.configButton.m_88315_(graphics, mouseX, mouseY, delta);
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            graphics.m_280430_(font, this.text, left, top + (innerHeight - 9) / 2, 0xFFFFFF);
        }

        public void save() {
            AbstractWidget abstractWidget = this.configButton;
            if (abstractWidget instanceof IConfigurable) {
                IConfigurable config = (IConfigurable)abstractWidget;
                config.save();
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }
    }
}

