/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.utilities.BlockEntry;

@OnlyIn(value=Dist.CLIENT)
public class PlaceChecker {
    public static boolean shouldPlaceBlock(Level world, BlockEntry blockEntry) {
        if (world == null || blockEntry == null) {
            return false;
        }
        BlockPos pos = blockEntry.blockPos;
        BlockState state = blockEntry.newBlockState;
        BlockEntity tileEntity = null;
        if (state == null) {
            return false;
        }
        BlockState toReplace = world.m_8055_(pos);
        BlockEntity toReplaceTE = world.m_7702_(pos);
        BlockState toReplaceOther = null;
        if (state.m_61138_((Property)BlockStateProperties.f_61391_) && state.m_61138_((Property)BlockStateProperties.f_61374_) && state.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.FOOT) {
            toReplaceOther = world.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            toReplaceOther = world.m_8055_(pos.m_7494_());
        }
        if (toReplace == state) {
            return false;
        }
        if (toReplace.m_60800_((BlockGetter)world, pos) == -1.0f || toReplaceOther != null && toReplaceOther.m_60800_((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        if (EffortlessBuildingClient.BUILD_SETTINGS.shouldProtectTileEntities() && toReplaceOther != null && toReplaceOther.m_155947_()) {
            return false;
        }
        boolean isNormalCube = state.m_60796_((BlockGetter)world, pos);
        return PlaceChecker.shouldPlace(world, pos, state, tileEntity, toReplace, toReplaceOther, isNormalCube);
    }

    private static boolean shouldPlace(Level level, BlockPos pos, BlockState state, BlockEntity tileEntity, BlockState toReplace, BlockState toReplaceOther, boolean isNormalCube) {
        return !PlaceChecker.shouldIgnoreBlockState(state);
    }

    private static boolean shouldIgnoreBlockState(BlockState state) {
        if (state.m_60734_() == Blocks.f_50454_) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61391_) && state.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.HEAD) {
            return true;
        }
        return state.m_60734_() instanceof PistonHeadBlock;
    }
}

