/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.ServerConfig;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockPlacerHelper;
import nl.requios.effortlessbuilding.utilities.BlockSet;
import nl.requios.effortlessbuilding.utilities.BlockUtilities;
import nl.requios.effortlessbuilding.utilities.InventoryHelper;

public class ServerBlockPlacer {
    private boolean isPlacingOrBreakingBlocks = false;
    private final Set<DelayedEntry> delayedEntries = Collections.synchronizedSet(new HashSet());
    private final Set<DelayedEntry> delayedEntriesView = Collections.unmodifiableSet(this.delayedEntries);

    public void placeBlocksDelayed(Player player, BlockSet blocks, long placeTime) {
        if (!this.checkAndNotifyAllowedToUseMod(player)) {
            return;
        }
        if (!this.validateBlockSet(player, blocks)) {
            return;
        }
        this.delayedEntries.add(new DelayedEntry(player, blocks, placeTime));
    }

    public void tick() {
        Iterator<DelayedEntry> iterator = this.delayedEntries.iterator();
        while (iterator.hasNext()) {
            DelayedEntry entry = iterator.next();
            long gameTime = entry.player.m_9236_().m_46467_();
            if (gameTime < entry.placeTime) continue;
            this.applyBlockSet(entry.player, entry.blocks);
            iterator.remove();
        }
    }

    public Set<DelayedEntry> getDelayedEntries() {
        return this.delayedEntriesView;
    }

    public void breakBlocks(Player player, BlockSet blocks) {
        this.applyBlockSet(player, blocks);
    }

    public void applyBlockSet(Player player, BlockSet blocks) {
        if (!this.checkAndNotifyAllowedToUseMod(player)) {
            return;
        }
        if (!this.validateBlockSet(player, blocks)) {
            return;
        }
        EffortlessBuilding.ITEM_USAGE_TRACKER.initialize();
        BlockSet undoSet = new BlockSet();
        for (BlockEntry block : blocks) {
            if (blocks.skipFirst && block.blockPos == blocks.firstPos || !this.applyBlockEntry(player, block)) continue;
            undoSet.add(block);
        }
        EffortlessBuilding.ITEM_USAGE_TRACKER.calculateMissingItems(player);
        if (!player.m_7500_()) {
            InventoryHelper.removeFromInventory(player, EffortlessBuilding.ITEM_USAGE_TRACKER.placed);
        }
        EffortlessBuilding.UNDO_REDO.addUndo(player, undoSet);
    }

    public void undoBlockSet(Player player, BlockSet blocks) {
        if (!EffortlessBuilding.UNDO_REDO.isAllowedToUndo(player)) {
            return;
        }
        EffortlessBuilding.ITEM_USAGE_TRACKER.initialize();
        BlockSet redoSet = new BlockSet();
        for (BlockEntry block : blocks) {
            if (blocks.skipFirst && block.blockPos == blocks.firstPos || !this.undoBlockEntry(player, block)) continue;
            redoSet.add(block);
        }
        EffortlessBuilding.ITEM_USAGE_TRACKER.calculateMissingItems(player);
        if (!player.m_7500_()) {
            InventoryHelper.removeFromInventory(player, EffortlessBuilding.ITEM_USAGE_TRACKER.placed);
        }
        EffortlessBuilding.UNDO_REDO.addRedo(player, redoSet);
    }

    private boolean applyBlockEntry(Player player, BlockEntry block) {
        boolean success;
        block.existingBlockState = player.m_9236_().m_8055_(block.blockPos);
        boolean breaking = BlockUtilities.isNullOrAir(block.newBlockState);
        if (!this.validateBlockEntry(player, block, breaking)) {
            return false;
        }
        this.isPlacingOrBreakingBlocks = true;
        if (breaking) {
            success = BlockPlacerHelper.breakBlock(player, block);
        } else if (EffortlessBuilding.ITEM_USAGE_TRACKER.increaseUsageCount(block.item, 1, player)) {
            success = BlockPlacerHelper.placeBlock(player, block);
        } else {
            success = false;
            EffortlessBuilding.log(player, ChatFormatting.RED + block.item.toString() + " not found in inventory.");
        }
        this.isPlacingOrBreakingBlocks = false;
        return success;
    }

    private boolean undoBlockEntry(Player player, BlockEntry block) {
        boolean success;
        boolean breaking = BlockUtilities.isNullOrAir(block.existingBlockState);
        BlockEntry tempBlockEntry = new BlockEntry(block.blockPos);
        BlockState temp = block.existingBlockState;
        tempBlockEntry.existingBlockState = block.newBlockState;
        tempBlockEntry.newBlockState = temp;
        if (!this.validateBlockEntry(player, tempBlockEntry, breaking)) {
            return false;
        }
        block.newBlockState = player.m_9236_().m_8055_(block.blockPos);
        this.isPlacingOrBreakingBlocks = true;
        if (breaking) {
            success = BlockPlacerHelper.breakBlock(player, tempBlockEntry);
        } else if (EffortlessBuilding.ITEM_USAGE_TRACKER.increaseUsageCount(tempBlockEntry.item, 1, player)) {
            success = BlockPlacerHelper.placeBlock(player, tempBlockEntry);
        } else {
            success = false;
            EffortlessBuilding.log(player, ChatFormatting.RED + tempBlockEntry.item.toString() + " not found in inventory.");
        }
        this.isPlacingOrBreakingBlocks = false;
        return success;
    }

    private boolean checkAndNotifyAllowedToUseMod(Player player) {
        if (!player.m_150110_().f_35938_) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "You are not allowed to build.");
            return false;
        }
        if (!this.isAllowedToUseMod(player)) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "You are not allowed to use Effortless Building.");
            return false;
        }
        return true;
    }

    private boolean isAllowedToUseMod(Player player) {
        if (!((Boolean)ServerConfig.validation.allowInSurvival.get()).booleanValue() && !player.m_7500_()) {
            return false;
        }
        if (((Boolean)ServerConfig.validation.useWhitelist.get()).booleanValue()) {
            return ((List)ServerConfig.validation.whitelist.get()).contains(player.m_36316_().getName());
        }
        return true;
    }

    private boolean validateBlockSet(Player player, BlockSet blocks) {
        if (blocks.isEmpty()) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "No blocks to place.");
            return false;
        }
        if (blocks.skipFirst && blocks.size() == 1 && blocks.iterator().next().blockPos == blocks.firstPos) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "No blocks to place because the first block was skipped.");
            return false;
        }
        if (blocks.size() > (Integer)ServerConfig.validation.maxBlocksPlacedAtOnce.get()) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "Too many blocks to place. Max: " + ServerConfig.validation.maxBlocksPlacedAtOnce.get());
            return false;
        }
        if (this.isMixedPlacingAndBreaking(player, blocks)) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "Cannot mix breaking and placing blocks.");
            return false;
        }
        return true;
    }

    private boolean isMixedPlacingAndBreaking(Player player, BlockSet blocks) {
        boolean breaking;
        Iterator<BlockEntry> iterator = blocks.iterator();
        BlockEntry anyBlock = iterator.next();
        if (blocks.skipFirst && anyBlock.blockPos == blocks.firstPos) {
            anyBlock = iterator.next();
        }
        boolean bl = breaking = anyBlock.newBlockState == null || anyBlock.newBlockState.m_60795_();
        while (iterator.hasNext()) {
            BlockEntry block = iterator.next();
            if (!(block.newBlockState == null || block.newBlockState.m_60795_() ? !breaking : breaking)) continue;
            return true;
        }
        return false;
    }

    private boolean validateBlockEntry(Player player, BlockEntry block, boolean breaking) {
        if (!player.m_9236_().m_46749_(block.blockPos)) {
            return false;
        }
        return !breaking || !BlockUtilities.isNullOrAir(block.existingBlockState);
    }

    public boolean isPlacingOrBreakingBlocks() {
        return this.isPlacingOrBreakingBlocks;
    }

    public record DelayedEntry(Player player, BlockSet blocks, long placeTime) {
    }
}

