/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.ClientConfig;
import nl.requios.effortlessbuilding.ClientEvents;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.create.AllSpecialTextures;
import nl.requios.effortlessbuilding.create.CreateClient;
import nl.requios.effortlessbuilding.systems.BuilderChain;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BlockPreviews {
    private final List<PlacedBlocksEntry> placedBlocksList = new ArrayList<PlacedBlocksEntry>();

    public void onTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.drawPlacedBlocks();
        this.drawLookAtPreview((Player)player);
        this.drawOutlineAtBreakPosition((Player)player);
    }

    public void drawPlacedBlocks() {
        if (((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            for (PlacedBlocksEntry placed2 : this.placedBlocksList) {
                int totalTime = placed2.breaking ? (Integer)ClientConfig.visuals.breakAnimationLength.get() : (Integer)ClientConfig.visuals.appearAnimationLength.get();
                if (totalTime <= 0) continue;
                float dissolve = ((float)ClientEvents.ticksInGame - placed2.time) / (float)totalTime;
                this.renderBlockPreviews(placed2.blocks, placed2.breaking, dissolve);
            }
        }
        this.placedBlocksList.removeIf(placed -> {
            int totalTime = placed.breaking ? (Integer)ClientConfig.visuals.breakAnimationLength.get() : (Integer)ClientConfig.visuals.appearAnimationLength.get();
            return placed.time + (float)totalTime < (float)ClientEvents.ticksInGame;
        });
    }

    public void drawLookAtPreview(Player player) {
        BlockSet blocks = EffortlessBuildingClient.BUILDER_CHAIN.getBlocks();
        if (blocks.size() == 0) {
            return;
        }
        if (EffortlessBuildingClient.BUILD_MODES.getBuildMode() == BuildModeEnum.DISABLED && blocks.size() == 1) {
            return;
        }
        if (EffortlessBuildingClient.BUILDER_CHAIN.getBuildingState() == BuilderChain.BuildingState.IDLE && ((Boolean)ClientConfig.visuals.onlyShowBlockPreviewsWhenBuilding.get()).booleanValue() && blocks.size() == 1) {
            return;
        }
        HashSet<BlockPos> coordinates = blocks.getCoordinates();
        BuilderChain.BuildingState state = EffortlessBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        String outlineID = "single";
        if (blocks.size() > 1) {
            outlineID = blocks.firstPos;
        }
        if (state != BuilderChain.BuildingState.BREAKING) {
            if (((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue() && blocks.size() < (Integer)ClientConfig.visuals.maxBlockPreviews.get()) {
                this.renderBlockPreviews(blocks, false, 0.0f);
                Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED).disableLineNormals().lineWidth(0.03125f).colored(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            } else {
                Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).disableLineNormals().lineWidth(0.0625f).colored(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            }
        } else {
            Outliner.getInstance().showCluster((Object)outlineID, coordinates).withFaceTexture((BindableTexture)AllSpecialTextures.THIN_CHECKERED).disableLineNormals().lineWidth(0.0625f).colored(new Color(0.8f, 0.1f, 0.1f, 1.0f));
        }
        if (state != BuilderChain.BuildingState.IDLE) {
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (BlockPos pos : coordinates) {
                if (pos.m_123341_() < minX) {
                    minX = pos.m_123341_();
                }
                if (pos.m_123341_() > maxX) {
                    maxX = pos.m_123341_();
                }
                if (pos.m_123342_() < minY) {
                    minY = pos.m_123342_();
                }
                if (pos.m_123342_() > maxY) {
                    maxY = pos.m_123342_();
                }
                if (pos.m_123343_() < minZ) {
                    minZ = pos.m_123343_();
                }
                if (pos.m_123343_() <= maxZ) continue;
                maxZ = pos.m_123343_();
            }
            BlockPos dim = new BlockPos(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            Object dimensions = "(";
            if (dim.m_123341_() > 1) {
                dimensions = (String)dimensions + dim.m_123341_() + "x";
            }
            if (dim.m_123343_() > 1) {
                dimensions = (String)dimensions + dim.m_123343_() + "x";
            }
            if (dim.m_123342_() > 1) {
                dimensions = (String)dimensions + dim.m_123342_() + "x";
            }
            if (((String)(dimensions = ((String)dimensions).substring(0, ((String)dimensions).length() - 1))).length() > 1) {
                dimensions = (String)dimensions + ")";
            }
            String msg = blocks.size() + " blocks " + (String)dimensions;
            EffortlessBuilding.log(player, msg, true);
        }
    }

    public void drawOutlineAtBreakPosition(Player player) {
        BlockState blockState;
        if (EffortlessBuildingClient.BUILD_MODES.getBuildMode() == BuildModeEnum.DISABLED) {
            return;
        }
        BuilderChain builderChain = EffortlessBuildingClient.BUILDER_CHAIN;
        BlockPos pos = builderChain.getStartPosForBreaking();
        if (pos == null) {
            return;
        }
        BuilderChain.AbilitiesState abilitiesState = builderChain.getAbilitiesState();
        if ((Boolean)ClientConfig.visuals.onlyShowBlockPreviewsWhenBuilding.get() != false ? abilitiesState == BuilderChain.AbilitiesState.NONE : abilitiesState != BuilderChain.AbilitiesState.CAN_BREAK) {
            return;
        }
        if (EffortlessBuildingClient.BUILDER_CHAIN.getLookingAtNear() != null) {
            return;
        }
        AABB aabb = new AABB(pos);
        if (player.m_9236_().m_46749_(pos) && !(blockState = player.m_9236_().m_8055_(pos)).m_60795_()) {
            aabb = blockState.m_60808_((BlockGetter)player.m_9236_(), pos).m_83215_().m_82338_(pos);
        }
        Outliner.getInstance().showAABB((Object)"break", aabb).disableLineNormals().lineWidth(0.015625f).colored(0x222222);
    }

    protected void renderBlockPreviews(BlockSet blocks, boolean breaking, float dissolve) {
        for (BlockEntry blockEntry : blocks) {
            this.renderBlockPreview(blockEntry, breaking, dissolve, blocks.firstPos, blocks.lastPos);
        }
    }

    protected void renderBlockPreview(BlockEntry blockEntry, boolean breaking, float dissolve, BlockPos firstPos, BlockPos lastPos) {
        if (blockEntry.newBlockState == null) {
            return;
        }
        BlockPos blockPos = blockEntry.blockPos;
        BlockState blockState = blockEntry.newBlockState;
        float scale = 0.5f;
        float alpha = 0.7f;
        if (dissolve > 0.0f) {
            float animationLength = 0.8f;
            double firstToSecond = lastPos.m_123331_((Vec3i)firstPos);
            double place = 0.0;
            if (firstToSecond > 0.5) {
                double placeFromFirst = firstPos.m_123331_((Vec3i)blockPos) / firstToSecond;
                double placeFromSecond = lastPos.m_123331_((Vec3i)blockPos) / firstToSecond;
                place = (placeFromFirst + (1.0 - placeFromSecond)) / 2.0;
            }
            float diff = dissolve - (float)(place *= (double)(1.0f - animationLength));
            float t = diff / animationLength;
            t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
            t = this.gain(t, 0.5f);
            if (!breaking) {
                scale = 0.5f + t * 0.3f;
                alpha = 0.7f + t * 0.3f;
            } else {
                t = 1.0f - t;
                scale = 0.5f + t * 0.5f;
                alpha = 0.7f + t * 0.3f;
            }
            alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        }
        CreateClient.GHOST_BLOCKS.showGhostState(blockPos.m_123344_(), blockState).at(blockPos).alpha(alpha).scale(scale).colored(blockEntry.invalid ? Color.RED : Color.WHITE);
    }

    private float gain(float x, float k) {
        float a = (float)(0.5 * Math.pow(2.0 * ((double)x < 0.5 ? (double)x : 1.0 - (double)x), k));
        return (double)x < 0.5 ? a : 1.0f - a;
    }

    public void onBlocksPlaced(BlockSet blocks) {
        if (!((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            return;
        }
        if (blocks.size() <= 1 || blocks.size() > (Integer)ClientConfig.visuals.maxBlockPreviews.get()) {
            return;
        }
        this.placedBlocksList.add(new PlacedBlocksEntry(ClientEvents.ticksInGame, false, new BlockSet(blocks)));
        Outliner.getInstance().keep((Object)Pair.of((Object)blocks.firstPos, (Object)((Integer)ClientConfig.visuals.appearAnimationLength.get())));
    }

    public void onBlocksBroken(BlockSet blocks) {
        if (!((Boolean)ClientConfig.visuals.showBlockPreviews.get()).booleanValue()) {
            return;
        }
        if (blocks.size() <= 1 || blocks.size() > (Integer)ClientConfig.visuals.maxBlockPreviews.get()) {
            return;
        }
        this.placedBlocksList.add(new PlacedBlocksEntry(ClientEvents.ticksInGame, true, new BlockSet(blocks)));
        Outliner.getInstance().keep((Object)Pair.of((Object)blocks.firstPos, (Object)((Integer)ClientConfig.visuals.breakAnimationLength.get())));
    }

    private void sortOnDistanceToPlayer(List<BlockPos> coordinates, Player player) {
        Collections.sort(coordinates, (lhs, rhs) -> {
            double lhsDistanceToPlayer = Vec3.m_82528_((Vec3i)lhs).m_82546_(player.m_20299_(1.0f)).m_82556_();
            double rhsDistanceToPlayer = Vec3.m_82528_((Vec3i)rhs).m_82546_(player.m_20299_(1.0f)).m_82556_();
            return (int)Math.signum(lhsDistanceToPlayer - rhsDistanceToPlayer);
        });
    }

    public static class PlacedBlocksEntry {
        float time;
        boolean breaking;
        BlockSet blocks;

        public PlacedBlocksEntry(float time, boolean breaking, BlockSet blocks) {
            this.time = time;
            this.breaking = breaking;
            this.blocks = blocks;
        }
    }
}

