/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import nl.requios.effortlessbuilding.AllGuiTextures;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.AbstractSimiWidget;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.Label;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreenList;
import nl.requios.effortlessbuilding.gui.elements.MiniButton;

public abstract class BaseModifierEntry<T extends BaseModifier>
extends ModifiersScreenList.Entry {
    public T modifier;
    protected AllGuiTextures background;
    protected MiniButton enableButton;
    protected Label nameLabel;
    protected MiniButton moveUpButton;
    protected MiniButton moveDownButton;
    protected MiniButton removeButton;
    protected Label reachLabel;
    protected static final int BACKGROUND_WIDTH = 226;
    protected static final int BACKGROUND_HEIGHT = 60;
    protected int left = 0;
    protected int right = 0;
    protected int top = 0;
    protected int bottom = 0;

    public BaseModifierEntry(ModifiersScreen screen, T modifier, Component name, AllGuiTextures background) {
        super(screen);
        this.modifier = modifier;
        this.background = background;
        this.enableButton = (MiniButton)((AbstractSimiWidget)new MiniButton(0, 0, 100, 9).showing(AllGuiTextures.ENABLE_BUTTON_BACKGROUND)).withCallback(() -> {
            modifier.enabled = !modifier.enabled;
            this.onValueChanged();
        });
        this.listeners.add(this.enableButton);
        this.nameLabel = new Label(65, 8, name);
        this.nameLabel.text = name;
        this.moveUpButton = (MiniButton)((AbstractSimiWidget)new MiniButton(0, 0, 9, 9).showing(AllGuiTextures.ARROW_UP)).withCallback(() -> {
            screen.moveModifierUp(this);
            this.onValueChanged();
        });
        this.moveUpButton.setToolTip((Component)Components.literal("Move up"));
        this.listeners.add(this.moveUpButton);
        this.moveDownButton = (MiniButton)((AbstractSimiWidget)new MiniButton(0, 0, 9, 9).showing(AllGuiTextures.ARROW_DOWN)).withCallback(() -> {
            screen.moveModifierDown(this);
            this.onValueChanged();
        });
        this.moveDownButton.setToolTip((Component)Components.literal("Move down"));
        this.listeners.add(this.moveDownButton);
        this.removeButton = (MiniButton)((AbstractSimiWidget)new MiniButton(0, 0, 9, 9).showing(AllGuiTextures.TRASH)).withCallback(() -> screen.removeModifier(this));
        this.removeButton.setToolTip((Component)Components.literal("Remove"));
        this.listeners.add(this.removeButton);
        this.reachLabel = new Label(0, 0, Components.immutableEmpty()).withShadow();
        this.listeners.add(this.reachLabel);
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        this.left = x + width / 2 - 113;
        this.right = x + width / 2 + 113;
        this.top = y;
        this.bottom = y + 60;
        this.background.render(guiGraphics, this.left, this.top);
        this.enableButton.m_252865_(this.left + 4);
        this.enableButton.m_253211_(this.top + 3);
        this.enableButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (((BaseModifier)this.modifier).enabled) {
            AllGuiTextures.CHECKMARK.render(guiGraphics, this.left + 5, this.top + 3);
        }
        this.nameLabel.m_252865_(this.left + 18);
        this.nameLabel.m_253211_(this.top + 4);
        this.nameLabel.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.moveUpButton.f_93624_ = this.screen.canMoveUp(this);
        this.moveDownButton.f_93624_ = this.screen.canMoveDown(this);
        this.moveUpButton.m_252865_(this.right - 31);
        this.moveUpButton.m_253211_(this.top + 3);
        this.moveUpButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.moveDownButton.m_252865_(this.right - 22);
        this.moveDownButton.m_253211_(this.top + 3);
        this.moveDownButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.removeButton.m_252865_(this.right - 13);
        this.removeButton.m_253211_(this.top + 3);
        this.removeButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void onValueChanged() {
        if (((BaseModifier)this.modifier).enabled) {
            this.enableButton.setToolTip((Component)Components.literal("Disable this modifier"));
        } else {
            this.enableButton.setToolTip((Component)Components.literal("Enable this modifier"));
        }
    }
}

