/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.create.CreateClient;
import nl.requios.effortlessbuilding.create.foundation.utility.AnimationTickHolder;
import nl.requios.effortlessbuilding.create.foundation.utility.CameraAngleAnimationService;
import nl.requios.effortlessbuilding.create.foundation.utility.worldWrappers.WrappedClientWorld;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String ITEM_PREFIX = "item.effortlessbuilding";
    private static final String BLOCK_PREFIX = "block.effortlessbuilding";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!ClientEvents.isGameActive() || event.phase != TickEvent.Phase.END) {
            return;
        }
        AnimationTickHolder.tick();
        CreateClient.GHOST_BLOCKS.tickGhosts();
        CameraAngleAnimationService.tick();
    }

    @SubscribeEvent
    public static void onLoadWorld(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world.m_5776_() && world instanceof ClientLevel && !(world instanceof WrappedClientWorld)) {
            CreateClient.invalidateRenderers();
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onUnloadWorld(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        CreateClient.invalidateRenderers();
        AnimationTickHolder.reset();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float pt = AnimationTickHolder.getPartialTicks();
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        CreateClient.GHOST_BLOCKS.renderAll(ms, (SuperRenderTypeBuffer)buffer);
        buffer.draw();
        RenderSystem.enableCull();
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        if (CameraAngleAnimationService.isYawAnimating()) {
            event.setYaw(CameraAngleAnimationService.getYaw(partialTicks));
        }
        if (CameraAngleAnimationService.isPitchAnimating()) {
            event.setPitch(CameraAngleAnimationService.getPitch(partialTicks));
        }
    }

    public static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }
}

