/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.capability.IPowerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerLevelCapability
implements IPowerLevel,
ICapabilitySerializable<CompoundTag> {
    public static final int MAX_POWER_LEVEL = 3;
    private int powerLevel = 0;

    @Override
    public int getPowerLevel() {
        return this.powerLevel;
    }

    @Override
    public int getNextPowerLevel() {
        return Math.min(this.getPowerLevel() + 1, 3);
    }

    @Override
    public void setPowerLevel(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    public boolean canIncreasePowerLevel() {
        return this.getPowerLevel() < 3;
    }

    @Override
    public void increasePowerLevel() {
        if (this.canIncreasePowerLevel()) {
            this.setPowerLevel(this.getPowerLevel() + 1);
        }
    }

    @Override
    public int getPlacementReach(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.reach.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.reach.level1.get();
            case 2 -> (Integer)CommonConfig.reach.level2.get();
            case 3 -> (Integer)CommonConfig.reach.level3.get();
            default -> (Integer)CommonConfig.reach.level0.get();
        };
    }

    @Override
    public int getBuildModeReach(Player player) {
        return this.getPlacementReach(player, false) + 6;
    }

    @Override
    public int getMaxBlocksPlacedAtOnce(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxBlocksPlacedAtOnce.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level0.get();
        };
    }

    @Override
    public int getMaxBlocksPerAxis(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxBlocksPerAxis.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPerAxis.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPerAxis.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPerAxis.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPerAxis.level0.get();
        };
    }

    @Override
    public int getMaxMirrorRadius(Player player, boolean nextPowerLevel) {
        if (player.m_7500_()) {
            return (Integer)CommonConfig.maxMirrorRadius.creative.get();
        }
        return switch (this.getPowerLevel() + (nextPowerLevel ? 1 : 0)) {
            case 1 -> (Integer)CommonConfig.maxMirrorRadius.level1.get();
            case 2 -> (Integer)CommonConfig.maxMirrorRadius.level2.get();
            case 3 -> (Integer)CommonConfig.maxMirrorRadius.level3.get();
            default -> (Integer)CommonConfig.maxMirrorRadius.level0.get();
        };
    }

    @Override
    public boolean isDisabled(Player player) {
        return this.getMaxBlocksPlacedAtOnce(player, false) <= 0 || this.getMaxBlocksPerAxis(player, false) <= 0;
    }

    @Override
    public boolean canBreakFar(Player player) {
        return player.m_150110_().f_35937_;
    }

    @Override
    public boolean canReplaceBlocks(Player player) {
        return player.m_150110_().f_35937_;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.POWER_LEVEL_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("powerLevel", this.getPowerLevel());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setPowerLevel(nbt.m_128451_("powerLevel"));
    }
}

