/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

public class RadialMirror
extends BaseModifier {
    public Vec3 position = new Vec3(0.5, 64.5, 0.5);
    public int slices = 4;
    public boolean alternate = false;
    public int radius = 20;
    public boolean drawLines = true;
    public boolean drawPlanes = false;

    public RadialMirror() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            this.position = Vec3.m_82528_((Vec3i)Minecraft.m_91087_().f_91074_.m_20183_());
        }
    }

    @Override
    public void findCoordinates(BlockSet blocks, Player player) {
        if (!this.enabled) {
            return;
        }
        BlockSet originalBlocks = new BlockSet(blocks);
        for (BlockEntry blockEntry : originalBlocks) {
            if (!this.isWithinRange(blockEntry.blockPos)) continue;
            this.performRadialMirror(blocks, blockEntry);
        }
    }

    @Override
    public void onPowerLevelChanged(int powerLevel) {
        this.radius = CapabilityHandler.getMaxMirrorRadius((Player)Minecraft.m_91087_().f_91074_, false);
    }

    public void performRadialMirror(BlockSet blocks, BlockEntry blockEntry) {
        double sliceAngle = Math.PI * 2 / (double)this.slices;
        Vec3 relStartVec = Vec3.m_82512_((Vec3i)blockEntry.blockPos).m_82546_(this.position);
        double startAngleToCenter = Mth.m_14136_((double)relStartVec.f_82479_, (double)relStartVec.f_82481_);
        if (startAngleToCenter < 0.0) {
            startAngleToCenter += Math.PI;
        }
        double startAngleInSlice = startAngleToCenter % sliceAngle;
        for (int i = 1; i < this.slices; ++i) {
            Vec3 relNewVec;
            BlockPos newBlockPos;
            boolean doAlternate;
            double curAngle = sliceAngle * (double)i;
            boolean bl = doAlternate = this.alternate && i % 2 == 1;
            if (doAlternate) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (blocks.containsKey(newBlockPos = BlockPos.m_274446_((Position)this.position.m_82549_(relNewVec = relStartVec.m_82524_((float)curAngle))))) continue;
            BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
            newBlockEntry.copyRotationSettingsFrom(blockEntry);
            double angleToCenter = Mth.m_14136_((double)relNewVec.f_82479_, (double)relNewVec.f_82481_);
            this.rotateBlockEntry(newBlockEntry, angleToCenter, doAlternate);
            blocks.add(newBlockEntry);
        }
    }

    private void rotateBlockEntry(BlockEntry blockEntry, double angleToCenter, boolean alternate) {
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            blockEntry.rotation = blockEntry.rotation.m_55952_(Rotation.CLOCKWISE_180);
            if (alternate) {
                // empty if block
            }
        } else if (angleToCenter < -0.7885397560510381) {
            blockEntry.rotation = blockEntry.rotation.m_55952_(Rotation.CLOCKWISE_90);
            if (alternate) {
                // empty if block
            }
        } else if (angleToCenter > 0.7822565707438585) {
            blockEntry.rotation = blockEntry.rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                // empty if block
            }
        } else if (alternate) {
            // empty if block
        }
    }

    private static BlockState rotateOriginalBlockState(Player player, BlockPos startPos, double startAngleToCenter, BlockState blockState) {
        BlockState newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.CLOCKWISE_180);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.COUNTERCLOCKWISE_90);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.CLOCKWISE_90);
        }
        return newBlockState;
    }

    private static BlockState rotateBlockState(Player player, BlockPos startPos, Vec3 relVec, BlockState blockState, boolean alternate) {
        BlockState newBlockState;
        double angleToCenter = Mth.m_14136_((double)relVec.f_82479_, (double)relVec.f_82481_);
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.CLOCKWISE_180);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.FRONT_BACK);
            }
        } else if (angleToCenter < -0.7885397560510381) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.CLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.LEFT_RIGHT);
            }
        } else if (angleToCenter > 0.7822565707438585) {
            newBlockState = blockState.rotate((LevelAccessor)player.m_9236_(), startPos, Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.LEFT_RIGHT);
            }
        } else {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.m_60715_(Mirror.FRONT_BACK);
            }
        }
        return newBlockState;
    }

    public boolean isWithinRange(BlockPos startPos) {
        return new Vec3((double)startPos.m_123341_() + 0.5, (double)startPos.m_123342_() + 0.5, (double)startPos.m_123343_() + 0.5).m_82546_(this.position).m_82556_() < (double)(this.radius * this.radius);
    }

    public int getReach() {
        return this.radius * 2;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128347_("positionX", this.position.f_82479_);
        compound.m_128347_("positionY", this.position.f_82480_);
        compound.m_128347_("positionZ", this.position.f_82481_);
        compound.m_128405_("slices", this.slices);
        compound.m_128379_("alternate", this.alternate);
        compound.m_128405_("radius", this.radius);
        compound.m_128379_("drawLines", this.drawLines);
        compound.m_128379_("drawPlanes", this.drawPlanes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.position = new Vec3(nbt.m_128459_("positionX"), nbt.m_128459_("positionY"), nbt.m_128459_("positionZ"));
        this.slices = nbt.m_128451_("slices");
        this.alternate = nbt.m_128471_("alternate");
        this.radius = nbt.m_128451_("radius");
        this.drawLines = nbt.m_128471_("drawLines");
        this.drawPlanes = nbt.m_128471_("drawPlanes");
    }
}

