/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.item.crafting;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.item.crafting.BucketFillingType;
import cech12.bucketlib.util.BucketLibUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketFillingShapelessRecipe
extends ShapelessRecipe {
    private final CraftingBookCategory category;
    private final List<Ingredient> ingredients;
    private final BucketFillingType fillingType;
    private final Fluid fluid;
    private final Block block;
    private final EntityType<?> entityType;

    public BucketFillingShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, NonNullList<Ingredient> ingredients, BucketFillingType fillingType, Fluid fluid, Block block, EntityType<?> entityType) {
        super(id, group, category, BucketFillingShapelessRecipe.getAssembledBucket(fillingType, fluid, block, entityType, ingredients.stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).toList()).flatMap(Collection::stream).toList()), ingredients);
        this.category = category;
        this.ingredients = ingredients;
        this.fillingType = fillingType;
        this.fluid = fluid;
        this.block = block;
        this.entityType = entityType;
    }

    private static ItemStack getAffectedBucket(List<ItemStack> itemStacks) {
        for (ItemStack stack : itemStacks) {
            if (!(stack.m_41720_() instanceof UniversalBucketItem) || !BucketLibUtil.isEmpty(stack)) continue;
            ItemStack bucket = stack.m_41777_();
            bucket.m_41764_(1);
            return bucket;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getAssembledBucket(BucketFillingType fillingType, Fluid fluid, Block block, EntityType<?> entityType, List<ItemStack> itemStacks) {
        ItemStack bucket = BucketFillingShapelessRecipe.getAffectedBucket(itemStacks);
        Item item = bucket.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem universalBucketItem = (UniversalBucketItem)item;
            if (fillingType == BucketFillingType.BLOCK && universalBucketItem.canHoldBlock(block)) {
                return BucketLibUtil.addBlock(bucket, block);
            }
            if (fillingType == BucketFillingType.ENTITY && universalBucketItem.canHoldEntity(entityType) && (fluid == null || universalBucketItem.canHoldFluid(fluid))) {
                if (fluid != null) {
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                }
                return BucketLibUtil.addEntityType(bucket, entityType);
            }
            if (fillingType == BucketFillingType.FLUID && universalBucketItem.canHoldFluid(fluid)) {
                return BucketLibUtil.addFluid(bucket, fluid);
            }
            if (fillingType == BucketFillingType.MILK && universalBucketItem.canMilkEntities()) {
                return BucketLibUtil.addMilk(bucket);
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        ItemStack bucket = BucketFillingShapelessRecipe.getAffectedBucket(inv.m_280657_());
        if (bucket == ItemStack.f_41583_) {
            return false;
        }
        UniversalBucketItem universalBucketItem = (UniversalBucketItem)bucket.m_41720_();
        return !(!super.m_5818_(inv, level) || this.fillingType == BucketFillingType.BLOCK && !universalBucketItem.canHoldBlock(this.block) || this.fillingType == BucketFillingType.ENTITY && (!universalBucketItem.canHoldEntity(this.entityType) || this.fluid != null && !universalBucketItem.canHoldFluid(this.fluid)) || this.fillingType == BucketFillingType.FLUID && !universalBucketItem.canHoldFluid(this.fluid) || this.fillingType == BucketFillingType.MILK && !universalBucketItem.canMilkEntities());
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        return BucketFillingShapelessRecipe.getAssembledBucket(this.fillingType, this.fluid, this.block, this.entityType, inv.m_280657_());
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BucketFillingShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public BucketFillingShapelessRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for bucket filling shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for bucket filling shapeless recipe. The maximum is 9.");
            }
            BucketFillingType fillingType = (BucketFillingType)BucketFillingType.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"filling_type", null), (Enum)BucketFillingType.FLUID);
            Fluid fluid = null;
            Block block = null;
            EntityType entityType = null;
            if (fillingType == BucketFillingType.BLOCK) {
                if (!json.has("block")) {
                    throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"block\" without a defined block.");
                }
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()));
            } else if (fillingType == BucketFillingType.ENTITY) {
                if (!json.has("entity")) {
                    throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"entity\" without a defined entity.");
                }
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("entity").getAsString()));
                fluid = json.has("fluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("fluid").getAsString())) : null;
            } else if (fillingType == BucketFillingType.FLUID) {
                if (!json.has("fluid")) {
                    throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"fluid\" without a defined fluid.");
                }
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("fluid").getAsString()));
            } else if (fillingType != BucketFillingType.MILK) {
                throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"" + String.valueOf((Object)fillingType) + "\".");
            }
            return new BucketFillingShapelessRecipe(id, s, craftingbookcategory, nonnulllist, fillingType, fluid, block, entityType);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)p_44276_.get(i), (boolean)false);
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public BucketFillingShapelessRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int i = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            BucketFillingType fillingType = (BucketFillingType)buffer.m_130066_(BucketFillingType.class);
            Fluid fluid = null;
            Block block = null;
            EntityType entityType = null;
            if (fillingType == BucketFillingType.BLOCK) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
            } else if (fillingType == BucketFillingType.ENTITY) {
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buffer.m_130281_());
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
                if (fluid == Fluids.f_76191_) {
                    fluid = null;
                }
            } else if (fillingType == BucketFillingType.FLUID) {
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
            }
            return new BucketFillingShapelessRecipe(id, s, craftingbookcategory, (NonNullList<Ingredient>)ingredients, fillingType, fluid, block, entityType);
        }

        public void toNetwork(FriendlyByteBuf buffer, BucketFillingShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.category);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130068_((Enum)recipe.fillingType);
            if (recipe.fillingType == BucketFillingType.BLOCK) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)recipe.block)));
            } else if (recipe.fillingType == BucketFillingType.ENTITY) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(recipe.entityType)));
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)(recipe.fluid != null ? recipe.fluid : Fluids.f_76191_))));
            } else if (recipe.fillingType == BucketFillingType.FLUID) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)recipe.fluid)));
            }
        }
    }
}

