/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.config;

import cech12.bucketlib.api.BucketLibTags;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.BooleanValue INFINITY_ENCHANTMENT_ENABLED;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Balance Options");
        INFINITY_ENCHANTMENT_ENABLED = builder.comment("Whether or not Infinity enchantment for modded buckets filled with fluids of the tag \"" + String.valueOf(BucketLibTags.Fluids.INFINITY_ENCHANTABLE.f_203868_()) + "\" should be enabled.").define("infinityEnchantmentEnabled", false);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

