/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;

public final class CodeFenced {
    public static final Construct codeFenced = new Construct();

    private CodeFenced() {
    }

    static {
        CodeFenced.codeFenced.name = "codeFenced";
        CodeFenced.codeFenced.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        CodeFenced.codeFenced.concrete = true;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        Construct closingFenceConstruct = new Construct();
        Construct nonLazyLine;
        int initialPrefix;
        int sizeOpen;
        int marker;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.closingFenceConstruct.tokenize = (context1, effects1, ok1, nok1) -> (StateMachine)this.new ClosingFenceStateMachine((TokenizeContext)context1, (Tokenizer.Effects)effects1, (State)ok1, (State)nok1).start;
            this.closingFenceConstruct.partial = true;
            this.nonLazyLine = new Construct();
            this.nonLazyLine.tokenize = (context1, effects1, ok1, nok1) -> new NonLazyLineStateMachine(context1, effects1, ok1, nok1)::start;
            this.nonLazyLine.partial = true;
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            Tokenizer.Event tail = context.getLastEvent();
            this.initialPrefix = tail != null && tail.token().type.equals("linePrefix") ? tail.context().sliceSerialize(tail.token(), true).length() : 0;
        }

        private State start(int code) {
            Assert.check(code == 96 || code == 126, "expected `` ` `` or `~`");
            this.effects.enter("codeFenced");
            this.effects.enter("codeFencedFence");
            this.effects.enter("codeFencedFenceSequence");
            this.marker = code;
            return this.sequenceOpen(code);
        }

        private State sequenceOpen(int code) {
            if (code == this.marker) {
                this.effects.consume(code);
                ++this.sizeOpen;
                return this::sequenceOpen;
            }
            this.effects.exit("codeFencedFenceSequence");
            return this.sizeOpen < 3 ? this.nok.step(code) : FactorySpace.create(this.effects, this::infoOpen, "whitespace").step(code);
        }

        private State infoOpen(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                return this.openAfter(code);
            }
            this.effects.enter("codeFencedFenceInfo");
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.info(code);
        }

        private State info(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEndingOrSpace(code)) {
                this.effects.exit("chunkString");
                this.effects.exit("codeFencedFenceInfo");
                return FactorySpace.create(this.effects, this::infoAfter, "whitespace").step(code);
            }
            if (code == 96 && code == this.marker) {
                return this.nok.step(code);
            }
            this.effects.consume(code);
            return this::info;
        }

        private State infoAfter(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                return this.openAfter(code);
            }
            this.effects.enter("codeFencedFenceMeta");
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.meta(code);
        }

        private State meta(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("chunkString");
                this.effects.exit("codeFencedFenceMeta");
                return this.openAfter(code);
            }
            if (code == 96 && code == this.marker) {
                return this.nok.step(code);
            }
            this.effects.consume(code);
            return this::meta;
        }

        private State openAfter(int code) {
            this.effects.exit("codeFencedFence");
            return this.context.isInterrupt() ? this.ok.step(code) : this.contentStart(code);
        }

        private State contentStart(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.after(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                return this.effects.attempt.hook(this.nonLazyLine, this.effects.attempt.hook(this.closingFenceConstruct, this::after, this.initialPrefix != 0 ? FactorySpace.create(this.effects, this::contentStart, "linePrefix", this.initialPrefix + 1) : this::contentStart), this::after).step(code);
            }
            this.effects.enter("codeFlowValue");
            return this.contentContinue(code);
        }

        private State contentContinue(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("codeFlowValue");
                return this.contentStart(code);
            }
            this.effects.consume(code);
            return this::contentContinue;
        }

        private State after(int code) {
            this.effects.exit("codeFenced");
            return this.ok.step(code);
        }

        class NonLazyLineStateMachine {
            private final TokenizeContext context;
            private final Tokenizer.Effects effects;
            private final State ok;
            private final State nok;

            public NonLazyLineStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
                this.context = context;
                this.effects = effects;
                this.ok = ok;
                this.nok = nok;
            }

            private State start(int code) {
                Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                this.effects.enter("lineEnding");
                this.effects.consume(code);
                this.effects.exit("lineEnding");
                return this::lineStart;
            }

            private State lineStart(int code) {
                return this.context.isOnLazyLine() ? this.nok.step(code) : this.ok.step(code);
            }
        }

        class ClosingFenceStateMachine {
            private final TokenizeContext context;
            private final Tokenizer.Effects effects;
            private final State ok;
            private final State nok;
            private int size;
            public final State start;

            public ClosingFenceStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
                this.context = context;
                this.effects = effects;
                this.ok = ok;
                this.nok = nok;
                this.start = FactorySpace.create(effects, this::closingSequenceStart, "linePrefix", context.getParser().constructs.nullDisable.contains("codeIndented") ? Integer.MAX_VALUE : 4);
            }

            private State closingSequenceStart(int code) {
                this.effects.enter("codeFencedFence");
                this.effects.enter("codeFencedFenceSequence");
                return this.closingSequence(code);
            }

            private State closingSequence(int code) {
                if (code == StateMachine.this.marker) {
                    this.effects.consume(code);
                    ++this.size;
                    return this::closingSequence;
                }
                if (this.size < StateMachine.this.sizeOpen) {
                    return this.nok.step(code);
                }
                this.effects.exit("codeFencedFenceSequence");
                return FactorySpace.create(this.effects, this::closingSequenceEnd, "whitespace").step(code);
            }

            private State closingSequenceEnd(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    this.effects.exit("codeFencedFence");
                    return this.ok.step(code);
                }
                return this.nok.step(code);
            }
        }
    }
}

