/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

public final class CharUtil {
    private CharUtil() {
    }

    public static boolean asciiAlpha(int code) {
        return code >= 97 && code <= 122 || code >= 65 && code <= 90;
    }

    public static boolean asciiDigit(int code) {
        return code >= 48 && code <= 57;
    }

    public static boolean asciiHexDigit(int code) {
        return CharUtil.asciiDigit(code) || code >= 97 && code <= 102 || code >= 65 && code <= 70;
    }

    public static boolean asciiAlphanumeric(int code) {
        return CharUtil.asciiDigit(code) || CharUtil.asciiAlpha(code);
    }

    public static boolean asciiPunctuation(int code) {
        return code >= 33 && code <= 47 || code >= 58 && code <= 64 || code >= 91 && code <= 96 || code >= 123 && code <= 126;
    }

    public static boolean asciiAtext(int code) {
        return CharUtil.asciiAlphanumeric(code) || code >= 35 && code <= 39 || code == 42 || code == 43 || code == 45 || code == 47 || code == 61 || code == 63 || code >= 94 && code <= 126;
    }

    public static boolean asciiControl(int code) {
        return code != Integer.MIN_VALUE && (code < 32 || code == 127);
    }

    public static boolean markdownLineEndingOrSpace(int code) {
        return code != Integer.MIN_VALUE && (code < 0 || code == 32);
    }

    public static boolean markdownLineEnding(int code) {
        return code != Integer.MIN_VALUE && code < -2;
    }

    public static boolean markdownSpace(int code) {
        return code == -2 || code == -1 || code == 32;
    }

    public static boolean unicodeWhitespace(int code) {
        return Character.isSpaceChar((char)code);
    }

    public static boolean unicodePunctuation(int code) {
        if (CharUtil.asciiPunctuation(code)) {
            return true;
        }
        int type = Character.getType((char)code);
        return type == 23 || type == 20 || type == 22 || type == 30 || type == 29 || type == 24 || type == 21;
    }
}

