/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

public final class FloatHeap {
    private final int maxSize;
    private final float[] heap;
    private int size;

    public FloatHeap(int maxSize) {
        this.maxSize = maxSize;
        this.heap = new float[maxSize + 1];
        this.size = 0;
    }

    public boolean offer(float value) {
        if (this.size >= this.maxSize) {
            if (value < this.heap[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.push(value);
        return true;
    }

    public float[] getHeap() {
        float[] result = new float[this.size];
        System.arraycopy(this.heap, 1, result, 0, this.size);
        return result;
    }

    public float poll() {
        if (this.size > 0) {
            float result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap(1);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public float peek() {
        return this.heap[1];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    private void push(float element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap(this.size);
    }

    private float updateTop(float value) {
        this.heap[1] = value;
        this.downHeap(1);
        return this.heap[1];
    }

    private void downHeap(int i) {
        float value = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < value) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !(this.heap[k] < this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = value;
    }

    private void upHeap(int origPos) {
        int i = origPos;
        float value = this.heap[i];
        for (int j = i >>> 1; j > 0 && value < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = value;
    }
}

