/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.FilterDirectory;
import guideme.internal.shaded.lucene.store.Lock;
import guideme.internal.shaded.lucene.store.LockObtainFailedException;
import guideme.internal.shaded.lucene.util.ThreadInterruptedException;
import java.io.IOException;

public final class SleepingLockWrapper
extends FilterDirectory {
    public static final long LOCK_OBTAIN_WAIT_FOREVER = -1L;
    public static long DEFAULT_POLL_INTERVAL = 1000L;
    private final long lockWaitTimeout;
    private final long pollInterval;

    public SleepingLockWrapper(Directory delegate, long lockWaitTimeout) {
        this(delegate, lockWaitTimeout, DEFAULT_POLL_INTERVAL);
    }

    public SleepingLockWrapper(Directory delegate, long lockWaitTimeout, long pollInterval) {
        super(delegate);
        this.lockWaitTimeout = lockWaitTimeout;
        this.pollInterval = pollInterval;
        if (lockWaitTimeout < 0L && lockWaitTimeout != -1L) {
            throw new IllegalArgumentException("lockWaitTimeout should be LOCK_OBTAIN_WAIT_FOREVER or a non-negative number (got " + lockWaitTimeout + ")");
        }
        if (pollInterval < 0L) {
            throw new IllegalArgumentException("pollInterval must be a non-negative number (got " + pollInterval + ")");
        }
    }

    @Override
    public Lock obtainLock(String lockName) throws IOException {
        LockObtainFailedException failureReason = null;
        long maxSleepCount = this.lockWaitTimeout / this.pollInterval;
        long sleepCount = 0L;
        while (true) {
            try {
                return this.in.obtainLock(lockName);
            }
            catch (LockObtainFailedException failed) {
                if (failureReason == null) {
                    failureReason = failed;
                }
                try {
                    Thread.sleep(this.pollInterval);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
                if (sleepCount++ < maxSleepCount || this.lockWaitTimeout == -1L) continue;
                String reason = "Lock obtain timed out: " + this.toString() + ": " + failureReason;
                throw new LockObtainFailedException(reason, failureReason);
            }
            break;
        }
    }

    @Override
    public String toString() {
        return "SleepingLockWrapper(" + this.in + ")";
    }
}

