/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ngram;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.ngram.NGramTokenFilter;
import java.util.Map;

public class NGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "nGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public NGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.requireInt(args, "minGramSize");
        this.maxGramSize = this.requireInt(args, "maxGramSize");
        this.preserveOriginal = this.getBoolean(args, "preserveOriginal", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public NGramFilterFactory() {
        throw NGramFilterFactory.defaultCtorException();
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new NGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

