/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.compound;

import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import guideme.internal.shaded.lucene.util.ResourceLoader;
import guideme.internal.shaded.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.Map;

public class DictionaryCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "dictionaryCompoundWord";
    private CharArraySet dictionary;
    private final String dictFile;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;

    public DictionaryCompoundWordTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.dictFile = this.require(args, "dictionary");
        this.minWordSize = this.getInt(args, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args, "onlyLongestMatch", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public DictionaryCompoundWordTokenFilterFactory() {
        throw DictionaryCompoundWordTokenFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.dictionary = super.getWordSet(loader, this.dictFile, false);
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.dictionary == null) {
            return input;
        }
        return new DictionaryCompoundWordTokenFilter(input, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

