/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytParagraph;
import guideme.render.RenderContext;
import guideme.style.TextStyle;

public class LytHeading
extends LytParagraph {
    private int depth = 1;

    public LytHeading() {
        this.setMarginTop(5);
        this.setMarginBottom(5);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        TextStyle style = switch (depth) {
            case 1 -> DefaultStyles.HEADING1;
            case 2 -> DefaultStyles.HEADING2;
            case 3 -> DefaultStyles.HEADING3;
            case 4 -> DefaultStyles.HEADING4;
            case 5 -> DefaultStyles.HEADING5;
            case 6 -> DefaultStyles.HEADING6;
            default -> DefaultStyles.BODY_TEXT;
        };
        this.setStyle(style);
    }

    @Override
    public void render(RenderContext context) {
        super.render(context);
        if (this.depth == 1) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x(), bounds.bottom() - 1, bounds.width(), 1, (ColorValue)SymbolicColor.HEADER1_SEPARATOR);
        } else if (this.depth == 2) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x(), bounds.bottom() - 1, bounds.width(), 1, (ColorValue)SymbolicColor.HEADER2_SEPARATOR);
        }
    }
}

