/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import guideme.compiler.IndexingContext;
import guideme.compiler.IndexingSink;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.FlowTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.flow.LytFlowLink;
import guideme.document.flow.LytFlowParent;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.TextTooltip;
import guideme.internal.GuidebookText;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLinkCompiler
extends FlowTagCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLinkCompiler.class);

    @Override
    public Set<String> getTagNames() {
        return Set.of("CommandLink");
    }

    @Override
    protected void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        String command = el.getAttributeString("command", "");
        if (command.isEmpty()) {
            parent.appendError(compiler, "command attribute is required", el);
            return;
        }
        if (!command.startsWith("/")) {
            parent.appendError(compiler, "command must start with /", el);
            return;
        }
        String sendCommand = command.substring(1);
        boolean closeGuide = MdxAttrs.getBoolean(compiler, parent, el, "close", false);
        String title = el.getAttributeString("title", "");
        LytFlowLink link = new LytFlowLink();
        link.setTooltip(CommandLinkCompiler.buildTooltip(title, command));
        ResourceLocation pageId = compiler.getPageId();
        link.setClickCallback(uiHost -> {
            LocalPlayer player;
            if (closeGuide) {
                int attempts = 5;
                while (Minecraft.m_91087_().f_91080_ != null) {
                    Minecraft.m_91087_().f_91080_.m_7379_();
                    if (--attempts > 0) continue;
                }
            }
            if ((player = Minecraft.m_91087_().f_91074_) == null) {
                LOG.info("Cannot send command without active player.");
            } else {
                LOG.info("Sending command from page {}: {}", (Object)pageId, (Object)sendCommand);
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(sendCommand);
            }
        });
        compiler.compileFlowContext(el.children(), (LytFlowParent)link);
        parent.append(link);
    }

    private static GuideTooltip buildTooltip(String title, String command) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        if (!title.isEmpty()) {
            tooltipLines.add((Component)Component.m_237113_((String)title));
        }
        MutableComponent commandTooltipLine = command.length() > 25 ? Component.m_237113_((String)(command.substring(0, 25) + "...")) : Component.m_237113_((String)command);
        tooltipLines.add((Component)GuidebookText.RunsCommand.text().m_130940_(ChatFormatting.DARK_GRAY));
        tooltipLines.add((Component)commandTooltipLine.m_130940_(ChatFormatting.DARK_GRAY));
        return new TextTooltip(tooltipLines);
    }

    @Override
    public void index(IndexingContext indexer, MdxJsxElementFields el, IndexingSink sink) {
        String title = el.getAttributeString("title", "");
        if (!title.isBlank()) {
            sink.appendText(el, title);
        }
        indexer.indexContent(el.children(), sink);
    }
}

