/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFilter
extends Filter<Fluid> {
    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.tag != null) {
            if (this.tag instanceof SingleElementTag) {
                ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)((Fluid)((SingleElementTag)this.tag).getElement()));
                if (key != null) {
                    compound.m_128359_("Fluid", key.toString());
                }
            } else {
                compound.m_128359_("Tag", this.tag.getName().toString());
            }
        }
        if (this.metadata != null) {
            compound.m_128365_("Metadata", (Tag)this.metadata);
        }
        if (this.exactMetadata) {
            compound.m_128379_("ExactMetadata", true);
        }
        if (this.destination != null) {
            compound.m_128365_("Destination", (Tag)this.destination.serializeNBT());
        }
        if (this.invert) {
            compound.m_128379_("Invert", true);
        }
        compound.m_128362_("ID", this.id);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        Fluid fluid;
        this.tag = null;
        if (compound.m_128425_("Fluid", 8) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(compound.m_128461_("Fluid")))) != null) {
            this.tag = new SingleElementTag<Fluid>(ForgeRegistries.FLUIDS.getKey((Object)fluid), fluid);
        }
        if (compound.m_128425_("Tag", 8)) {
            this.tag = TagUtils.getFluidTag(new ResourceLocation(compound.m_128461_("Tag")));
        }
        this.metadata = compound.m_128425_("Metadata", 10) ? compound.m_128469_("Metadata") : null;
        this.exactMetadata = compound.m_128425_("ExactMetadata", 1) ? compound.m_128471_("ExactMetadata") : false;
        if (compound.m_128425_("Destination", 10)) {
            this.destination = new DirectionalPosition();
            this.destination.deserializeNBT(compound.m_128469_("Destination"));
        } else {
            this.destination = null;
        }
        this.invert = compound.m_128425_("Invert", 1) ? compound.m_128471_("Invert") : false;
        this.id = compound.m_128425_("ID", 11) ? compound.m_128342_("ID") : UUID.randomUUID();
    }
}

