/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LootModifierInjectItem
extends LootModifier {
    public static final Supplier<Codec<LootModifierInjectItem>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootModifierInjectItem.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(LootModifierInjectItem::getItemStack), (App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(LootModifierInjectItem::getLootTables), (App)Codec.INT.optionalFieldOf("maxStackSize", (Object)1).forGetter(LootModifierInjectItem::getMaxStackSize))).apply((Applicative)inst, LootModifierInjectItem::new)));
    private final ItemStack itemStack;
    private final List<String> lootTables;
    private final int maxStackSize;

    public LootModifierInjectItem(LootItemCondition[] conditionsIn, ItemStack itemStack, List<String> lootTables, int maxStackSize) {
        super(conditionsIn);
        this.itemStack = itemStack;
        this.lootTables = lootTables;
        this.maxStackSize = maxStackSize;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public List<String> getLootTables() {
        return this.lootTables;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getLootTables().contains(context.getQueriedLootTableId().toString())) {
            ItemStack stack = this.getItemStack().m_41777_();
            stack.m_41764_(context.m_230907_().m_216339_(1, this.getMaxStackSize() + 1));
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

