/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLike;

public interface IIngredientCollection<T, M>
extends IIngredientCollectionLike<T, M, T> {
    public boolean contains(T var1);

    public boolean contains(T var1, M var2);

    default public boolean containsAll(Iterable<? extends T> instances) {
        for (T instance : instances) {
            if (this.contains(instance)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(Iterable<? extends T> instances, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return instances.iterator().hasNext() == !this.isEmpty();
        }
        for (T instance : instances) {
            if (this.contains(instance, matchCondition)) continue;
            return false;
        }
        return true;
    }

    public int count(T var1, M var2);

    @Override
    public Iterator<T> iterator(T var1, M var2);

    default public T[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (Object t : this) {
            array[i++] = t;
        }
        return array;
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }
}

