/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.init;

import cofh.lib.util.DeferredRegisterCoFH;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mrthomas20121.thermal_extra.fluid.ClientFluidTypeExtension;
import mrthomas20121.thermal_extra.fluid.FluidHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ThermalExtraFluids {
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"thermal_extra");
    public static final DeferredRegisterCoFH<FluidType> FLUID_TYPES = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"thermal_extra");
    public static FluidHolder SOUL_INFUSED = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("soul_infused"), ThermalExtraFluids.hot(1000), MapColor.f_283750_, 15).metal();
    public static FluidHolder TWINITE = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("twinite"), ThermalExtraFluids.hot(1000), MapColor.f_283765_, 15).metal();
    public static FluidHolder SHELLITE = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("shellite"), ThermalExtraFluids.hot(1300), MapColor.f_283931_, 15).metal();
    public static FluidHolder DRAGONSTEEL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("dragonsteel"), ThermalExtraFluids.hot(1500), MapColor.f_283772_, 15).metal();
    public static FluidHolder ABYSSAL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("abyssal"), ThermalExtraFluids.hot(1500), MapColor.f_283778_, 15).metal();
    public static FluidHolder RAW_ALUMINUM = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_aluminum"), ThermalExtraFluids.hot(500), MapColor.f_283750_, 15).metal();
    public static FluidHolder RAW_ARCANE_GOLD = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_arcane_gold"), ThermalExtraFluids.hot(500), MapColor.f_283832_, 15).metal();
    public static FluidHolder RAW_COPPER = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_copper"), ThermalExtraFluids.hot(500), MapColor.f_283750_, 15).metal();
    public static FluidHolder RAW_GOLD = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_gold"), ThermalExtraFluids.hot(500), MapColor.f_283832_, 15).metal();
    public static FluidHolder RAW_IRON = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_iron"), ThermalExtraFluids.hot(500), MapColor.f_283877_, 15).metal();
    public static FluidHolder RAW_LEAD = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_lead"), ThermalExtraFluids.hot(500), MapColor.f_283908_, 15).metal();
    public static FluidHolder RAW_NICKEL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_nickel"), ThermalExtraFluids.hot(500), MapColor.f_283843_, 15).metal();
    public static FluidHolder RAW_OSMIUM = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_osmium"), ThermalExtraFluids.hot(500), MapColor.f_283869_, 15).metal();
    public static FluidHolder RAW_SILVER = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_silver"), ThermalExtraFluids.hot(500), MapColor.f_283779_, 15).metal();
    public static FluidHolder RAW_TIN = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_tin"), ThermalExtraFluids.hot(500), MapColor.f_283779_, 15).metal();
    public static FluidHolder RAW_URANIUM = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_uranium"), ThermalExtraFluids.hot(500), MapColor.f_283856_, 15).metal();
    public static FluidHolder RAW_ZINC = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("raw_zinc"), ThermalExtraFluids.hot(500), MapColor.f_283818_, 15).metal();
    public static FluidHolder DIESEL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("diesel"), ThermalExtraFluids.hot(300), MapColor.f_283750_, 15);
    public static FluidHolder GASOLINE = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("gasoline"), ThermalExtraFluids.hot(300), MapColor.f_283908_, 15);
    public static FluidHolder NAPHTHA = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("naphtha"), ThermalExtraFluids.hot(300), MapColor.f_283908_, 15);
    public static FluidHolder PARAFFIN_WAX = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("paraffin_wax"), 300, MapColor.f_283942_, 5);
    public static FluidHolder LUBRICANT = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("lubricant"), ThermalExtraFluids.liquid(800), MapColor.f_283843_, 10);
    public static FluidHolder SUNFLOWER_OIL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("sunflower_oil"), ThermalExtraFluids.liquid(500), MapColor.f_283832_, 3);
    public static FluidHolder CRYSTALLIZED_SUNFLOWER_OIL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("crystallized_sunflower_oil"), ThermalExtraFluids.liquid(500), MapColor.f_283832_, 5);
    public static FluidHolder REFINED_SUNFLOWER_OIL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("refined_sunflower_oil"), ThermalExtraFluids.liquid(500), MapColor.f_283750_, 10);
    public static FluidHolder FLUX_INFUSED_OIL = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("flux_infused_oil"), 300, MapColor.f_283750_, 15);
    public static FluidHolder POLYOLEFIN = ThermalExtraFluids.register(ThermalExtraFluids.modLoc("polyolefin"), ThermalExtraFluids.liquid(500), MapColor.f_283907_, 5);

    private static FluidType.Properties hot(int temp) {
        return FluidType.Properties.create().density(2000).viscosity(10000).temperature(temp).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).motionScale(0.0023333333333333335).canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null);
    }

    private static FluidType.Properties liquid(int temp) {
        return FluidType.Properties.create().density(2000).viscosity(10000).temperature(temp).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).motionScale(0.0023333333333333335).canExtinguish(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER);
    }

    private static ResourceLocation modLoc(String name) {
        return new ResourceLocation("thermal_extra", name);
    }

    private static BlockBehaviour.Properties createProperties(MapColor color, int lightLevel) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280170_().m_60910_().m_60977_().m_60978_(100.0f).m_60953_(state -> lightLevel).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_);
    }

    public static FluidHolder register(ResourceLocation name, int temp, MapColor mapColor, int lightLevel) {
        return ThermalExtraFluids.register(name, ThermalExtraFluids.hot(temp).lightLevel(lightLevel), ThermalExtraFluids.createProperties(mapColor, lightLevel));
    }

    public static FluidHolder register(ResourceLocation name, FluidType.Properties typeProps, MapColor mapColor, int lightLevel) {
        return ThermalExtraFluids.register(name, typeProps.descriptionId("fluid_type.thermal_extra." + name.m_135815_()), ThermalExtraFluids.createProperties(mapColor, lightLevel));
    }

    public static FluidHolder register(ResourceLocation name, int temp, BlockBehaviour.Properties properties) {
        return ThermalExtraFluids.register(name, ThermalExtraFluids.hot(temp), properties);
    }

    public static FluidHolder register(ResourceLocation name, FluidType.Properties typeProps, BlockBehaviour.Properties properties) {
        final ResourceLocation flow = new ResourceLocation(name.m_135827_(), "block/fluids/" + name.m_135815_() + "_flow");
        final ResourceLocation still = new ResourceLocation(name.m_135827_(), "block/fluids/" + name.m_135815_() + "_still");
        Supplier<FluidType> fluidType = () -> new FluidType(typeProps){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new ClientFluidTypeExtension(still, flow));
            }
        };
        return new FluidHolder(name, fluidType, properties);
    }
}

