/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BackpackManager
extends SavedData {
    private static final String NAME = "simplybackpacks_backpack_data";
    private static final HashMap<UUID, BackpackData> data = new HashMap();
    public static final BackpackManager blankClient = new BackpackManager();

    public HashMap<UUID, BackpackData> getMap() {
        return data;
    }

    public static BackpackManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (BackpackManager)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(BackpackManager::load, BackpackManager::new, NAME);
        }
        return blankClient;
    }

    public Optional<BackpackData> getBackpack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public BackpackData getOrCreateBackpack(UUID uuid, Backpack tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.m_77762_();
            return new BackpackData((UUID)id, tier);
        });
    }

    public void removeBackpack(UUID uuid) {
        this.getBackpack(uuid).ifPresent(backpack -> {
            backpack.getOptional().invalidate();
            data.remove(uuid);
            this.m_77762_();
        });
    }

    public LazyOptional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public static BackpackManager load(CompoundTag nbt) {
        if (nbt.m_128441_("Backpacks")) {
            ListTag list = nbt.m_128437_("Backpacks", 10);
            list.forEach(backpackNBT -> BackpackData.fromNBT((CompoundTag)backpackNBT).ifPresent(backpack -> data.put(backpack.getUuid(), (BackpackData)backpack)));
        }
        return new BackpackManager();
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag backpacks = new ListTag();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT()));
        compound.m_128365_("Backpacks", (Tag)backpacks);
        return compound;
    }
}

