/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BackpackData {
    private final UUID uuid;
    private Backpack tier;
    private final SBItemHandler inventory;
    private final LazyOptional<IItemHandler> optional;
    public final Metadata meta = new Metadata();
    private FilterItemHandler filter = new FilterItemHandler();

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getHandler() {
        return this.inventory;
    }

    public FilterItemHandler getFilter() {
        return this.filter;
    }

    public Backpack getTier() {
        return this.tier;
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public BackpackData(UUID uuid, Backpack tier) {
        this.uuid = uuid;
        this.tier = tier;
        this.inventory = new SBItemHandler(tier.slots);
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public BackpackData(UUID uuid, CompoundTag incomingNBT) {
        this.uuid = uuid;
        this.tier = Backpack.values()[Math.min(incomingNBT.m_128451_("Tier"), Backpack.ULTIMATE.ordinal())];
        this.inventory = new SBItemHandler(this.tier.slots);
        if (incomingNBT.m_128469_("Inventory").m_128441_("Size") && incomingNBT.m_128469_("Inventory").m_128451_("Size") != this.tier.slots) {
            incomingNBT.m_128469_("Inventory").m_128405_("Size", this.tier.slots);
        }
        this.inventory.deserializeNBT(incomingNBT.m_128469_("Inventory"));
        this.filter = new FilterItemHandler();
        this.filter.deserializeNBT(incomingNBT.m_128469_("Filter"));
        this.optional = LazyOptional.of(() -> this.inventory);
        if (incomingNBT.m_128441_("Metadata")) {
            this.meta.deserializeNBT(incomingNBT.m_128469_("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Optional<BackpackData> fromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("UUID")) {
            UUID uuid = nbt.m_128342_("UUID");
            return Optional.of(new BackpackData(uuid, nbt));
        }
        return Optional.empty();
    }

    public void upgrade(Backpack newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier.slots);
        }
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UUID", this.uuid);
        nbt.m_128405_("Tier", this.tier.ordinal());
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        nbt.m_128365_("Metadata", (Tag)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("firstPlayer", this.firstAccessedPlayer);
            nbt.m_128356_("firstTime", this.firstAccessedTime);
            nbt.m_128359_("lastPlayer", this.lastAccessedPlayer);
            nbt.m_128356_("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.m_128461_("firstPlayer");
            this.firstAccessedTime = nbt.m_128454_("firstTime");
            this.lastAccessedPlayer = nbt.m_128461_("lastPlayer");
            this.lastAccessedTime = nbt.m_128454_("lastTime");
        }
    }
}

