/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.commands.SBCommands;
import com.flanks255.simplybackpacks.configuration.CommonConfiguration;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.crafting.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.crafting.TargetNBTIngredient;
import com.flanks255.simplybackpacks.data.Generator;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.OpenMessage;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.flanks255.simplybackpacks.util.RecipeUnlocker;
import com.flanks255.simplybackpacks.util.TagLookup;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static SimpleChannel NETWORK;
    public static final TagKey<Item> HOLDS_ITEMS;
    public static final TagKey<Item> CURIOS_BACK;
    public static final TagKey<Enchantment> SOULBOUND;
    public static final TagLookup<Enchantment> SOULBOUND_LOOKUP;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final RegistryObject<RecipeSerializer<?>> COPYRECIPE;
    public static final RegistryObject<MenuType<SBContainer>> SBCONTAINER;
    public static final RegistryObject<MenuType<FilterContainer>> FILTERCONTAINER;
    public static final RegistryObject<Item> COMMONBACKPACK;
    public static final RegistryObject<Item> UNCOMMONBACKPACK;
    public static final RegistryObject<Item> RAREBACKPACK;
    public static final RegistryObject<Item> EPICBACKPACK;
    public static final RegistryObject<Item> ULTIMATEBACKPACK;
    private final NonNullList<KeyMapping> keyBinds = NonNullList.m_122779_();

    public SimplyBackpacks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfiguration.COMMON_CONFIG);
        bus.addListener(ConfigCache::listen);
        MinecraftForge.EVENT_BUS.addListener(SBCommands::listen);
        bus.addListener(this::setup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(this::clientStuff);
            bus.addListener(this::registerKeyBinding);
            MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
            bus.addListener(this::creativeTabEvent);
        }
        bus.addListener(Generator::gatherData);
        bus.addListener(this::onEnqueueIMC);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        BackpackUtils.curiosLoaded = ModList.get().isLoaded("curios");
        RecipeUnlocker.register(MODID, MinecraftForge.EVENT_BUS, 2);
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (BackpackUtils.curiosLoaded) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)TargetNBTIngredient.Serializer.NAME, (IIngredientSerializer)TargetNBTIngredient.SERIALIZER));
        NETWORK = SBNetwork.register();
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        ItemStack stack;
        Optional curioslot;
        if (event.getEntity().f_36096_ instanceof SBContainer || event.getEntity().m_6047_() || event.getItem().m_32055_().m_41720_() instanceof BackpackItem) {
            return;
        }
        if (BackpackUtils.curiosLoaded && (curioslot = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)event.getEntity(), BackpackItem::isBackpack)).isPresent() && BackpackItem.pickupEvent(event, stack = ((SlotResult)curioslot.get()).stack())) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        Inventory playerInv = event.getEntity().m_150109_();
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack2 = playerInv.m_8020_(i);
            if (!(stack2.m_41720_() instanceof BackpackItem) || !BackpackItem.pickupEvent(event, stack2)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (((KeyMapping)this.keyBinds.get(0)).m_90859_()) {
            NETWORK.sendToServer((Object)new ToggleMessage());
        }
        if (((KeyMapping)this.keyBinds.get(1)).m_90859_()) {
            NETWORK.sendToServer((Object)new OpenMessage());
        }
    }

    private void registerKeyBinding(RegisterKeyMappingsEvent event) {
        this.keyBinds.add(0, (Object)new KeyMapping("key.simplybackpacks.backpackpickup.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyMapping("key.simplybackpacks.backpackopen.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.simplybackpacks.category"));
        event.register((KeyMapping)this.keyBinds.get(0));
        event.register((KeyMapping)this.keyBinds.get(1));
    }

    private void creativeTabEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().compareTo(CreativeModeTabs.f_256869_) == 0) {
            event.m_246326_((ItemLike)COMMONBACKPACK.get());
            event.m_246326_((ItemLike)UNCOMMONBACKPACK.get());
            event.m_246326_((ItemLike)RAREBACKPACK.get());
            event.m_246326_((ItemLike)EPICBACKPACK.get());
            event.m_246326_((ItemLike)ULTIMATEBACKPACK.get());
        }
    }

    private void clientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)SBCONTAINER.get()), SBGui::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FILTERCONTAINER.get()), FilterGui::new);
    }

    static {
        HOLDS_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "holds_items"));
        CURIOS_BACK = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("curios", "back"));
        SOULBOUND = TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)new ResourceLocation("forge", "soulbound"));
        SOULBOUND_LOOKUP = new TagLookup<Enchantment>(ForgeRegistries.ENCHANTMENTS, SOULBOUND);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        COPYRECIPE = RECIPES.register("backpack_upgrade", CopyBackpackDataRecipe.Serializer::new);
        SBCONTAINER = CONTAINERS.register("sb_container", () -> IForgeMenuType.create(SBContainer::fromNetwork));
        FILTERCONTAINER = CONTAINERS.register("filter_container", () -> IForgeMenuType.create(FilterContainer::fromNetwork));
        COMMONBACKPACK = ITEMS.register("commonbackpack", () -> new BackpackItem("commonbackpack", Backpack.COMMON));
        UNCOMMONBACKPACK = ITEMS.register("uncommonbackpack", () -> new BackpackItem("uncommonbackpack", Backpack.UNCOMMON));
        RAREBACKPACK = ITEMS.register("rarebackpack", () -> new BackpackItem("rarebackpack", Backpack.RARE));
        EPICBACKPACK = ITEMS.register("epicbackpack", () -> new BackpackItem("epicbackpack", Backpack.EPIC));
        ULTIMATEBACKPACK = ITEMS.register("ultimatebackpack", () -> new BackpackItem("ultimatebackpack", Backpack.ULTIMATE));
    }
}

