/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.setup;

import com.direwolf20.laserio.client.blockentityrenders.LaserConnectorAdvBERender;
import com.direwolf20.laserio.client.blockentityrenders.LaserConnectorBERender;
import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.client.events.ClientEvents;
import com.direwolf20.laserio.client.events.EventTooltip;
import com.direwolf20.laserio.client.events.KeybindHandler;
import com.direwolf20.laserio.client.screens.CardChemicalScreen;
import com.direwolf20.laserio.client.screens.CardEnergyScreen;
import com.direwolf20.laserio.client.screens.CardFluidScreen;
import com.direwolf20.laserio.client.screens.CardHolderScreen;
import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.CardRedstoneScreen;
import com.direwolf20.laserio.client.screens.FilterBasicScreen;
import com.direwolf20.laserio.client.screens.FilterCountScreen;
import com.direwolf20.laserio.client.screens.FilterNBTScreen;
import com.direwolf20.laserio.client.screens.FilterTagScreen;
import com.direwolf20.laserio.client.screens.LaserNodeScreen;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserConnectorBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.setup.Registration;
import java.awt.Color;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="laserio", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.LASER_NODE_BLOCK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.LASER_CONNECTOR_BLOCK.get()), (RenderType)RenderType.m_110463_());
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        MinecraftForge.EVENT_BUS.register(EventTooltip.class);
        MinecraftForge.EVENT_BUS.register((Object)new KeybindHandler());
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.LASER_NODE_CONTAINER.get()), LaserNodeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_ITEM_CONTAINER.get()), CardItemScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_FLUID_CONTAINER.get()), CardFluidScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_ENERGY_CONTAINER.get()), CardEnergyScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_REDSTONE_CONTAINER.get()), CardRedstoneScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_HOLDER_CONTAINER.get()), CardHolderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.FILTER_BASIC_CONTAINER.get()), FilterBasicScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.FILTER_COUNT_CONTAINER.get()), FilterCountScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.FILTER_TAG_CONTAINER.get()), FilterTagScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.FILTER_NBT_CONTAINER.get()), FilterNBTScreen::new);
        });
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)Registration.CARD_ITEM.get()), (ResourceLocation)new ResourceLocation("laserio", "mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack));
            ItemProperties.register((Item)((Item)Registration.CARD_FLUID.get()), (ResourceLocation)new ResourceLocation("laserio", "mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack));
            ItemProperties.register((Item)((Item)Registration.CARD_ENERGY.get()), (ResourceLocation)new ResourceLocation("laserio", "mode"), (stack, level, living, id) -> BaseCard.getTransferMode(stack));
            ItemProperties.register((Item)((Item)Registration.CARD_REDSTONE.get()), (ResourceLocation)new ResourceLocation("laserio", "mode"), (stack, level, living, id) -> CardRedstone.getTransferMode(stack));
        });
        if (MekanismIntegration.isLoaded()) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)Registration.CARD_CHEMICAL_CONTAINER.get()), CardChemicalScreen::new);
                ItemProperties.register((Item)((Item)Registration.CARD_CHEMICAL.get()), (ResourceLocation)new ResourceLocation("laserio", "mode"), (stack, level, living, id) -> CardChemical.getTransferMode(stack));
            });
        }
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LASER_CONNECTOR_BE.get(), LaserConnectorBERender::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LASER_NODE_BE.get(), LaserNodeBERender::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.LASER_CONNECTOR_ADV_BE.get(), LaserConnectorAdvBERender::new);
    }

    @SubscribeEvent
    public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(EventTooltip.CopyPasteTooltipComponent.Data.class, EventTooltip.CopyPasteTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KeybindHandler.OPEN_CARD_HOLDER);
        event.register(KeybindHandler.TOGGLE_CARD_HOLDER_PULLING);
    }

    @SubscribeEvent
    static void itemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.m_92689_((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getNamedTransferMode(stack) == BaseCard.TransferMode.SENSOR) {
                    Color color = LaserNodeBERender.COLORS[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.COLORS[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.CARD_ITEM.get()});
        colors.m_92689_((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getNamedTransferMode(stack) == BaseCard.TransferMode.SENSOR) {
                    Color color = LaserNodeBERender.COLORS[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.COLORS[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.CARD_FLUID.get()});
        if (MekanismIntegration.isLoaded()) {
            colors.m_92689_((stack, index) -> {
                if (index == 2) {
                    if (BaseCard.getNamedTransferMode(stack) == BaseCard.TransferMode.SENSOR) {
                        Color color = LaserNodeBERender.COLORS[BaseCard.getRedstoneChannel(stack)];
                        return color.getRGB();
                    }
                    Color color = LaserNodeBERender.COLORS[BaseCard.getChannel(stack)];
                    return color.getRGB();
                }
                return -1;
            }, new ItemLike[]{(ItemLike)Registration.CARD_CHEMICAL.get()});
        }
        colors.m_92689_((stack, index) -> {
            if (index == 2) {
                if (BaseCard.getNamedTransferMode(stack) == BaseCard.TransferMode.SENSOR) {
                    Color color = LaserNodeBERender.COLORS[BaseCard.getRedstoneChannel(stack)];
                    return color.getRGB();
                }
                Color color = LaserNodeBERender.COLORS[BaseCard.getChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.CARD_ENERGY.get()});
        colors.m_92689_((stack, index) -> {
            if (index == 2) {
                Color color = LaserNodeBERender.COLORS[CardRedstone.getRedstoneChannel(stack)];
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.CARD_REDSTONE.get()});
        colors.m_92689_((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LASER_NODE_ITEM.get()});
        colors.m_92689_((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LASER_CONNECTOR_ITEM.get()});
        colors.m_92689_((stack, index) -> {
            if (index == 1) {
                Color color = new Color(255, 0, 0, 255);
                return color.getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)Registration.LASER_CONNECTOR_ADV_ITEM.get()});
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, env, pos, index) -> {
            BlockEntity patt11754$temp;
            if (env != null && pos != null && (patt11754$temp = env.m_7702_(pos)) instanceof LaserNodeBE) {
                LaserNodeBE laserNodeBE = (LaserNodeBE)patt11754$temp;
                Color color = laserNodeBE.getColor();
                return FastColor.ARGB32.m_13660_((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LASER_NODE_BLOCK.get()});
        event.register((state, env, pos, index) -> {
            BlockEntity patt12307$temp;
            if (env != null && pos != null && (patt12307$temp = env.m_7702_(pos)) instanceof LaserConnectorBE) {
                LaserConnectorBE laserConnectorBE = (LaserConnectorBE)patt12307$temp;
                Color color = laserConnectorBE.getColor();
                return FastColor.ARGB32.m_13660_((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LASER_CONNECTOR_BLOCK.get()});
        event.register((state, env, pos, index) -> {
            BlockEntity patt12880$temp;
            if (env != null && pos != null && (patt12880$temp = env.m_7702_(pos)) instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)patt12880$temp;
                Color color = laserConnectorAdvBE.getColor();
                return FastColor.ARGB32.m_13660_((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            return FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        }, new Block[]{(Block)Registration.LASER_CONNECTOR_ADV_BLOCK.get()});
    }
}

