/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism.client.chemicalparticle;

import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.MekanismModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChemicalFlowParticleData
implements ParticleOptions {
    private final ChemicalStack<?> chemicalStack;
    private final String type;
    protected final double targetX;
    protected final double targetY;
    protected final double targetZ;
    protected final int ticksPerBlock;
    public static final ParticleOptions.Deserializer<ChemicalFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ChemicalFlowParticleData>(){

        @Nonnull
        public ChemicalFlowParticleData fromCommand(ParticleType<ChemicalFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String type = reader.readString();
            reader.expect(' ');
            double tx = reader.readDouble();
            reader.expect(' ');
            double ty = reader.readDouble();
            reader.expect(' ');
            double tz = reader.readDouble();
            reader.expect(' ');
            int ticks = reader.readInt();
            return new ChemicalFlowParticleData((ChemicalStack<?>)GasStack.EMPTY, tx, ty, tz, ticks, type);
        }

        public ChemicalFlowParticleData fromNetwork(ParticleType<ChemicalFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            String type = buffer.m_130277_();
            ChemicalType chemicalType = ChemicalType.fromString((String)type);
            if (chemicalType == ChemicalType.GAS) {
                return new ChemicalFlowParticleData((ChemicalStack<?>)ChemicalUtils.readGasStack((FriendlyByteBuf)buffer), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt(), type);
            }
            if (chemicalType == ChemicalType.INFUSION) {
                return new ChemicalFlowParticleData((ChemicalStack<?>)ChemicalUtils.readInfusionStack((FriendlyByteBuf)buffer), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt(), type);
            }
            if (chemicalType == ChemicalType.PIGMENT) {
                return new ChemicalFlowParticleData((ChemicalStack<?>)ChemicalUtils.readPigmentStack((FriendlyByteBuf)buffer), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt(), type);
            }
            if (chemicalType == ChemicalType.SLURRY) {
                return new ChemicalFlowParticleData((ChemicalStack<?>)ChemicalUtils.readSlurryStack((FriendlyByteBuf)buffer), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt(), type);
            }
            return null;
        }
    };

    public ChemicalFlowParticleData(ChemicalStack<?> chemicalStack, double tx, double ty, double tz, int ticks, String type) {
        this.chemicalStack = chemicalStack.copy();
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        this.ticksPerBlock = ticks;
        this.type = type;
    }

    @Nonnull
    public ParticleType<ChemicalFlowParticleData> m_6012_() {
        return (ParticleType)MekanismModParticles.CHEMICAL_FLOW_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type);
        ChemicalUtils.writeChemicalStack((FriendlyByteBuf)buffer, this.chemicalStack);
        buffer.writeDouble(this.targetX);
        buffer.writeDouble(this.targetY);
        buffer.writeDouble(this.targetZ);
        buffer.writeInt(this.ticksPerBlock);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d %s", this.m_6012_(), this.targetX, this.targetY, this.targetZ, this.ticksPerBlock, this.type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChemicalStack<?> getChemicalStack() {
        return this.chemicalStack;
    }
}

