/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class MekanismStatics {
    public static Capability<IGasHandler> GAS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGasHandler>(){});
    public static Capability<IInfusionHandler> INFUSION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInfusionHandler>(){});
    public static Capability<IPigmentHandler> PIGMENT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPigmentHandler>(){});
    public static Capability<ISlurryHandler> SLURRY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISlurryHandler>(){});

    public static Capability<? extends IChemicalHandler<?, ?>> getCapabilityForChemical(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> GAS_CAPABILITY;
            case ChemicalType.INFUSION -> INFUSION_CAPABILITY;
            case ChemicalType.PIGMENT -> PIGMENT_CAPABILITY;
            case ChemicalType.SLURRY -> SLURRY_CAPABILITY;
        };
    }

    public static boolean doesItemStackHoldChemicals(ItemStack itemStack) {
        return !MekanismStatics.getFirstChemicalOnItemStack(itemStack).isEmpty();
    }

    public static ChemicalStack<?> getFirstChemicalOnItemStack(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return GasStack.EMPTY;
        }
        ItemStack testStack = itemStack.m_41777_();
        if (testStack.m_41613_() > 1) {
            testStack.m_41764_(1);
        }
        for (ChemicalType chemicalType : ChemicalType.values()) {
            LazyOptional chemicalHandlerOptional = testStack.getCapability(MekanismStatics.getCapabilityForChemical(chemicalType));
            if (!chemicalHandlerOptional.isPresent()) continue;
            IChemicalHandler chemicalHandler = (IChemicalHandler)chemicalHandlerOptional.resolve().get();
            for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty()) continue;
                return chemicalStack;
            }
        }
        return GasStack.EMPTY;
    }

    public static List<ChemicalStack<?>> getAllChemicalsOnItemStack(ItemStack itemStack) {
        ArrayList chemicalStackList = new ArrayList();
        if (itemStack.m_41619_()) {
            return chemicalStackList;
        }
        ItemStack testStack = itemStack.m_41777_();
        if (testStack.m_41613_() > 1) {
            testStack.m_41764_(1);
        }
        for (ChemicalType chemicalType : ChemicalType.values()) {
            LazyOptional chemicalHandlerOptional = testStack.getCapability(MekanismStatics.getCapabilityForChemical(chemicalType));
            if (!chemicalHandlerOptional.isPresent()) continue;
            IChemicalHandler chemicalHandler = (IChemicalHandler)chemicalHandlerOptional.resolve().get();
            for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty()) continue;
                chemicalStackList.add(chemicalStack);
            }
        }
        return chemicalStackList;
    }

    public static List<String> getTagsFromItemStack(ItemStack itemStack) {
        ArrayList<String> tagsList = new ArrayList<String>();
        List<ChemicalStack<?>> chemicalStackList = MekanismStatics.getAllChemicalsOnItemStack(itemStack);
        for (ChemicalStack<?> chemicalStack : chemicalStackList) {
            chemicalStack.getType().getTags().forEach(t -> {
                String tag = t.f_203868_().toString().toLowerCase(Locale.ROOT);
                if (!tagsList.contains(tag)) {
                    tagsList.add(tag);
                }
            });
        }
        return tagsList;
    }

    public static boolean isValidChemicalForHandler(IChemicalHandler<?, ?> handler, ChemicalStack<?> chemicalStack) {
        if (handler instanceof IGasHandler) {
            return chemicalStack instanceof GasStack;
        }
        if (handler instanceof ISlurryHandler) {
            return chemicalStack instanceof SlurryStack;
        }
        if (handler instanceof IPigmentHandler) {
            return chemicalStack instanceof PigmentStack;
        }
        if (handler instanceof IInfusionHandler) {
            return chemicalStack instanceof InfusionStack;
        }
        return false;
    }
}

