/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.ChemicalStackKey;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.BaseCardCache;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class MekanismCardCache {
    public final BaseCardCache baseCardCache;
    public final List<ChemicalStack<?>> filteredChemicals;
    public final Map<ChemicalStackKey, Boolean> filterCacheChemical = new Object2BooleanOpenHashMap();
    public final Map<ChemicalStackKey, Integer> filterCountsChemical = new Object2IntOpenHashMap();

    public MekanismCardCache(BaseCardCache baseCardCache) {
        this.baseCardCache = baseCardCache;
        this.filteredChemicals = this.baseCardCache.filterCard.equals(ItemStack.f_41583_) ? new ArrayList() : this.getFilteredChemicals();
    }

    public List<ChemicalStack<?>> getFilteredChemicals() {
        ArrayList filteredChemicals = new ArrayList();
        ItemStack filterCard = this.baseCardCache.filterCard;
        FilterBasicHandler filterSlotHandler = filterCard.m_41720_() instanceof FilterBasic ? FilterBasic.getInventory(filterCard) : FilterCount.getInventory(filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            for (ChemicalType chemicalType : ChemicalType.values()) {
                LazyOptional chemicalHandlerOptional = itemStack.getCapability(MekanismStatics.getCapabilityForChemical(chemicalType));
                if (!chemicalHandlerOptional.isPresent()) continue;
                IChemicalHandler chemicalHandler = (IChemicalHandler)chemicalHandlerOptional.resolve().get();
                for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                    ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                    if (chemicalStack.isEmpty()) continue;
                    filteredChemicals.add(chemicalStack);
                }
            }
        }
        return filteredChemicals;
    }

    public boolean isStackValidForCard(ChemicalStack<?> testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.equals(ItemStack.f_41583_)) {
            return true;
        }
        ChemicalStackKey key = new ChemicalStackKey(testStack);
        if (this.filterCacheChemical.containsKey(key)) {
            return this.filterCacheChemical.get(key);
        }
        if (filterCard.m_41720_() instanceof FilterMod) {
            for (ChemicalStack<?> stack : this.filteredChemicals) {
                if (!stack.getTypeRegistryName().m_135827_().equals(testStack.getTypeRegistryName().m_135827_())) continue;
                this.filterCacheChemical.put(key, this.baseCardCache.isAllowList);
                return this.baseCardCache.isAllowList;
            }
        } else if (filterCard.m_41720_() instanceof FilterTag) {
            for (TagKey tagKey : testStack.getType().getTags().toList()) {
                String tag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                if (!this.baseCardCache.filterTags.contains(tag)) continue;
                this.filterCacheChemical.put(key, this.baseCardCache.isAllowList);
                return this.baseCardCache.isAllowList;
            }
        } else {
            for (ChemicalStack<?> stack : this.filteredChemicals) {
                if (!key.equals(new ChemicalStackKey(stack))) continue;
                this.filterCacheChemical.put(key, this.baseCardCache.isAllowList);
                return this.baseCardCache.isAllowList;
            }
        }
        this.filterCacheChemical.put(key, !this.baseCardCache.isAllowList);
        return !this.baseCardCache.isAllowList;
    }

    public int getFilterAmt(ChemicalStack<?> testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.equals(ItemStack.f_41583_)) {
            return 0;
        }
        if (!(filterCard.m_41720_() instanceof FilterCount)) {
            return -1;
        }
        ChemicalStackKey key = new ChemicalStackKey(testStack);
        if (this.filterCountsChemical.containsKey(key)) {
            return this.filterCountsChemical.get(key);
        }
        FilterCountHandler filterSlotHandler = FilterCount.getInventory(filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            ChemicalStack<?> chemicalStack;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.m_41619_() || (chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(itemStack)).isEmpty() || !key.equals(new ChemicalStackKey(chemicalStack))) continue;
            int mbAmt = FilterCount.getSlotAmount(filterCard, i);
            this.filterCountsChemical.put(key, mbAmt);
            return mbAmt;
        }
        this.filterCountsChemical.put(key, 0);
        return 0;
    }
}

