/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.events.ServerTickHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.ChemicalStackKey;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ChemicalFlowParticleData;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleDataChemical;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleRenderDataChemical;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.NodeSideCache;
import com.direwolf20.laserio.util.SensorCardCache;
import com.direwolf20.laserio.util.StockerCardCache;
import com.direwolf20.laserio.util.WeakConsumerWrapper;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.joml.Vector3f;

public class MekanismCache {
    public final Map<LaserNodeBE.SideConnection, Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>>> facingHandlerChemical = new HashMap();
    private final Map<LaserNodeBE.SideConnection, Map<ChemicalType, NonNullConsumer<LazyOptional<IChemicalHandler<?, ?>>>>> connectionInvalidatorChemical = new HashMap();
    public final Map<ExtractorCardCache, Map<ChemicalStackKey, List<InserterCardCache>>> inserterCacheChemical = new HashMap<ExtractorCardCache, Map<ChemicalStackKey, List<InserterCardCache>>>();
    private final LaserNodeBE laserNodeBE;
    private final Random random = new Random();

    public MekanismCache(LaserNodeBE laserNodeBE) {
        this.laserNodeBE = laserNodeBE;
    }

    public boolean senseChemicals(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.laserNodeBE.m_58899_().m_121945_(sensorCardCache.direction);
        Level level = this.laserNodeBE.m_58904_();
        assert (level != null);
        if (!level.m_46749_(adjacentPos)) {
            return false;
        }
        NodeSideCache nodeSideCache = this.laserNodeBE.nodeSideCaches[sensorCardCache.direction.ordinal()];
        Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> chemicalHandlerMap = this.getAttachedChemicalTanks(sensorCardCache.direction, sensorCardCache.sneaky);
        if (chemicalHandlerMap == null || chemicalHandlerMap.isEmpty()) {
            if (this.laserNodeBE.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.laserNodeBE.rendersChecked = false;
                this.laserNodeBE.clearCachedInventories();
                this.laserNodeBE.redstoneChecked = false;
            }
            return false;
        }
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        if (filter.m_41619_()) {
            if (this.laserNodeBE.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.laserNodeBE.rendersChecked = false;
                this.laserNodeBE.clearCachedInventories();
                this.laserNodeBE.redstoneChecked = false;
            }
            return false;
        }
        if (filter.m_41720_() instanceof FilterBasic) {
            List<ChemicalStack<?>> filteredChemicals = sensorCardCache.mekanismCardCache.getFilteredChemicals();
            ArrayList filteredChemicalsOriginal = new ArrayList(filteredChemicals);
            block0: for (Map.Entry<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> entry : chemicalHandlerMap.entrySet()) {
                if (!entry.getValue().isPresent()) continue;
                IChemicalHandler chemicalHandler = (IChemicalHandler)entry.getValue().resolve().get();
                for (ChemicalStack chemicalStack : filteredChemicalsOriginal) {
                    if (!MekanismStatics.isValidChemicalForHandler(chemicalHandler, chemicalStack)) continue;
                    for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                        ChemicalStack stackInTank = chemicalHandler.getChemicalInTank(tank);
                        if (!new ChemicalStackKey(chemicalStack).equals(new ChemicalStackKey(stackInTank))) continue;
                        filteredChemicals.remove(chemicalStack);
                        if (!andMode) break block0;
                    }
                }
            }
            filterMatched = andMode ? filteredChemicals.size() == 0 : filteredChemicals.size() < filteredChemicalsOriginal.size();
        } else if (filter.m_41720_() instanceof FilterCount) {
            List<ChemicalStack<?>> filteredChemicals = sensorCardCache.mekanismCardCache.getFilteredChemicals();
            ArrayList filteredChemicalsOriginal = new ArrayList(filteredChemicals);
            block3: for (Map.Entry<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> entry : chemicalHandlerMap.entrySet()) {
                if (!entry.getValue().isPresent()) continue;
                IChemicalHandler chemicalHandler = (IChemicalHandler)entry.getValue().resolve().get();
                for (ChemicalStack chemicalStack : filteredChemicalsOriginal) {
                    if (!MekanismStatics.isValidChemicalForHandler(chemicalHandler, chemicalStack)) continue;
                    int desiredAmt = sensorCardCache.mekanismCardCache.getFilterAmt(chemicalStack);
                    for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                        long amtHad;
                        ChemicalStack stackInTank = chemicalHandler.getChemicalInTank(tank);
                        if (!new ChemicalStackKey(chemicalStack).equals(new ChemicalStackKey(stackInTank)) || (amtHad = stackInTank.getAmount()) < (long)desiredAmt || sensorCardCache.exact && amtHad > (long)desiredAmt) continue;
                        filteredChemicals.remove(chemicalStack);
                        if (!andMode) break block3;
                    }
                }
            }
            filterMatched = andMode ? filteredChemicals.size() == 0 : filteredChemicals.size() < filteredChemicalsOriginal.size();
        } else if (filter.m_41720_() instanceof FilterTag) {
            List<String> tags = sensorCardCache.getFilterTags();
            int tagsToMatch = tags.size();
            block6: for (Map.Entry<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> entry : chemicalHandlerMap.entrySet()) {
                if (!entry.getValue().isPresent()) continue;
                IChemicalHandler chemicalHandler = (IChemicalHandler)entry.getValue().resolve().get();
                for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                    ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                    for (TagKey tagKey : chemicalStack.getType().getTags().toList()) {
                        String chemicalTag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                        if (!tags.contains(chemicalTag)) continue;
                        tags.remove(chemicalTag);
                        if (andMode) continue;
                        break block6;
                    }
                }
            }
            if (andMode) {
                filterMatched = tags.size() == 0;
            } else {
                boolean bl = filterMatched = tags.size() < tagsToMatch;
            }
        }
        if (this.laserNodeBE.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.laserNodeBE.rendersChecked = false;
            this.laserNodeBE.clearCachedInventories();
            this.laserNodeBE.redstoneChecked = false;
        }
        return true;
    }

    public boolean stockChemicals(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.laserNodeBE.m_58899_().m_121945_(stockerCardCache.direction);
        Level level = this.laserNodeBE.m_58904_();
        assert (level != null);
        if (!level.m_46749_(adjacentPos)) {
            return false;
        }
        Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> chemicalHandlerMap = this.getAttachedChemicalTanks(stockerCardCache.direction, stockerCardCache.sneaky);
        if (chemicalHandlerMap == null || chemicalHandlerMap.isEmpty()) {
            return false;
        }
        ItemStack filter = stockerCardCache.filterCard;
        if (filter.m_41619_() || !stockerCardCache.isAllowList) {
            return false;
        }
        for (Map.Entry<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> entry : chemicalHandlerMap.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            IChemicalHandler chemicalHandler = (IChemicalHandler)entry.getValue().resolve().get();
            if (filter.m_41720_() instanceof FilterBasic || filter.m_41720_() instanceof FilterCount) {
                boolean foundItems;
                if (stockerCardCache.regulate && filter.m_41720_() instanceof FilterCount && this.regulateChemicalStocker(stockerCardCache, chemicalHandler, entry.getKey())) {
                    return true;
                }
                if (!this.canAnyChemicalFiltersFit(chemicalHandler, stockerCardCache) || !(foundItems = this.findChemicalStackForStocker(stockerCardCache, chemicalHandler, entry.getKey()))) continue;
                return true;
            }
            if (!(filter.m_41720_() instanceof FilterTag)) continue;
        }
        return false;
    }

    public boolean regulateChemicalStocker(StockerCardCache stockerCardCache, IChemicalHandler stockerTank, ChemicalType chemicalType) {
        List<ChemicalStack<?>> filteredChemicalsList = stockerCardCache.mekanismCardCache.getFilteredChemicals();
        for (ChemicalStack<?> chemicalStack : filteredChemicalsList) {
            int desiredAmt = stockerCardCache.mekanismCardCache.getFilterAmt(chemicalStack);
            int amtHad = 0;
            for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                ChemicalStack stackInTank = stockerTank.getChemicalInTank(tank);
                if (!new ChemicalStackKey(chemicalStack).equals(new ChemicalStackKey(stackInTank))) continue;
                amtHad = (int)((long)amtHad + stackInTank.getAmount());
            }
            if (amtHad <= desiredAmt) continue;
            chemicalStack.setAmount((long)Math.min(amtHad - desiredAmt, stockerCardCache.extractAmt));
            if (!this.extractChemicalStack(stockerCardCache, stockerTank, chemicalStack, chemicalType)) continue;
            return true;
        }
        return false;
    }

    public boolean canAnyChemicalFiltersFit(IChemicalHandler chemicalHandler, StockerCardCache stockerCardCache) {
        for (ChemicalStack<?> chemicalStack : stockerCardCache.mekanismCardCache.getFilteredChemicals()) {
            long amtReturned;
            if (!MekanismStatics.isValidChemicalForHandler(chemicalHandler, chemicalStack) || (amtReturned = chemicalHandler.insertChemical(chemicalStack, Action.SIMULATE).getAmount()) >= chemicalStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    public boolean findChemicalStackForStocker(StockerCardCache stockerCardCache, IChemicalHandler stockerTank, ChemicalType chemicalType) {
        boolean isCount = stockerCardCache.filterCard.m_41720_() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        CopyOnWriteArrayList filteredChemicalsList = new CopyOnWriteArrayList(stockerCardCache.mekanismCardCache.getFilteredChemicals());
        filteredChemicalsList.removeIf(chemicalStack -> !this.canChemicalFitInTank(stockerTank, (ChemicalStack<?>)chemicalStack));
        if (filteredChemicalsList.isEmpty()) {
            return false;
        }
        if (isCount) {
            for (ChemicalStack chemicalStack2 : filteredChemicalsList) {
                for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                    long amtHad;
                    ChemicalStack tankStack = stockerTank.getChemicalInTank(tank);
                    if (!tankStack.isEmpty() && !new ChemicalStackKey(chemicalStack2).equals(new ChemicalStackKey(tankStack))) continue;
                    int filterAmt = stockerCardCache.mekanismCardCache.getFilterAmt(chemicalStack2);
                    long amtNeeded = (long)filterAmt - (amtHad = tankStack.getAmount());
                    if (amtNeeded <= 0L) {
                        filteredChemicalsList.remove(chemicalStack2);
                        continue;
                    }
                    chemicalStack2.setAmount(Math.min(amtNeeded, (long)extractAmt));
                }
            }
        }
        if (filteredChemicalsList.isEmpty()) {
            return false;
        }
        for (ChemicalStack chemicalStack3 : filteredChemicalsList) {
            HashMap<InserterCardCache, ChemicalStack> insertHandlers = new HashMap<InserterCardCache, ChemicalStack>();
            if (!isCount) {
                chemicalStack3.setAmount((long)extractAmt);
            }
            long amtNeeded = chemicalStack3.getAmount();
            for (InserterCardCache inserterCardCache : this.laserNodeBE.getChannelMatchInserters(stockerCardCache)) {
                LaserNodeChemicalHandler laserNodeChemicalHandler;
                if (!inserterCardCache.mekanismCardCache.isStackValidForCard(chemicalStack3) || (laserNodeChemicalHandler = this.getLaserNodeHandlerChemical(inserterCardCache, chemicalType)) == null) continue;
                IChemicalHandler<?, ?> handler = laserNodeChemicalHandler.handler;
                chemicalStack3.setAmount(amtNeeded);
                ChemicalStack extractStack = handler.extractChemical(chemicalStack3, Action.SIMULATE);
                if (extractStack.isEmpty()) continue;
                insertHandlers.put(inserterCardCache, extractStack);
                if ((amtNeeded -= extractStack.getAmount()) != 0L) continue;
                break;
            }
            if (insertHandlers.isEmpty() || stockerCardCache.exact && amtNeeded != 0L) continue;
            for (Map.Entry entry : insertHandlers.entrySet()) {
                InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
                ChemicalStack insertStack = (ChemicalStack)entry.getValue();
                LaserNodeChemicalHandler laserNodeChemicalHandler = this.getLaserNodeHandlerChemical(inserterCardCache, chemicalType);
                IChemicalHandler<?, ?> handler = laserNodeChemicalHandler.handler;
                long amtReturned = stockerTank.insertChemical(insertStack, Action.SIMULATE).getAmount();
                insertStack.setAmount(insertStack.getAmount() - amtReturned);
                ChemicalStack drainedStack = handler.extractChemical(insertStack, Action.EXECUTE);
                stockerTank.insertChemical(drainedStack, Action.EXECUTE);
                this.drawParticlesChemical(drainedStack, inserterCardCache.direction, inserterCardCache.be, stockerCardCache.be, stockerCardCache.direction, inserterCardCache.cardSlot, stockerCardCache.cardSlot);
            }
            return true;
        }
        return false;
    }

    public boolean canChemicalFitInTank(IChemicalHandler stockerTank, ChemicalStack<?> chemicalStack) {
        if (!MekanismStatics.isValidChemicalForHandler(stockerTank, chemicalStack)) {
            return false;
        }
        return stockerTank.insertChemical(chemicalStack, Action.SIMULATE).getAmount() < chemicalStack.getAmount();
    }

    public boolean sendChemicals(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.laserNodeBE.m_58899_().m_121945_(extractorCardCache.direction);
        Level level = this.laserNodeBE.m_58904_();
        assert (level != null);
        if (!level.m_46749_(adjacentPos)) {
            return false;
        }
        Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> chemicalHandlerMap = this.getAttachedChemicalTanks(extractorCardCache.direction, extractorCardCache.sneaky);
        if (chemicalHandlerMap == null || chemicalHandlerMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> entry : chemicalHandlerMap.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            IChemicalHandler chemicalHandler = (IChemicalHandler)entry.getValue().resolve().get();
            for (int tank = 0; tank < chemicalHandler.getTanks(); ++tank) {
                ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty() || !extractorCardCache.mekanismCardCache.isStackValidForCard(chemicalStack)) continue;
                ChemicalStack extractStack = chemicalStack.copy();
                extractStack.setAmount((long)extractorCardCache.extractAmt);
                if (extractorCardCache.filterCard.m_41720_() instanceof FilterCount) {
                    long amtInInv;
                    long amtAllowedToRemove;
                    int filterCount = extractorCardCache.mekanismCardCache.getFilterAmt(extractStack);
                    if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = chemicalStack.getAmount()) - (long)filterCount) <= 0L) continue;
                    long amtRemaining = Math.min(extractStack.getAmount(), amtAllowedToRemove);
                    extractStack.setAmount(amtRemaining);
                }
                if (!(extractorCardCache.exact ? this.extractChemicalStackExact(extractorCardCache, chemicalHandler, extractStack, entry.getKey()) : this.extractChemicalStack(extractorCardCache, chemicalHandler, extractStack, entry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean extractChemicalStack(ExtractorCardCache extractorCardCache, IChemicalHandler fromInventory, ChemicalStack<?> extractStack, ChemicalType chemicalType) {
        long totalAmtNeeded = extractStack.getAmount();
        long amtToExtract = extractStack.getAmount();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.laserNodeBE.getRR(extractorCardCache);
            inserterCardCaches = this.laserNodeBE.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeChemicalHandler laserNodeChemicalHandler = this.getLaserNodeHandlerChemical(inserterCardCache, chemicalType);
            if (laserNodeChemicalHandler == null) continue;
            IChemicalHandler<?, ?> handler = laserNodeChemicalHandler.handler;
            if (inserterCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int filterCount = inserterCardCache.mekanismCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    long currentAmt;
                    long neededAmt;
                    ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                    if (!chemicalStack.isEmpty() && !new ChemicalStackKey(chemicalStack).equals(new ChemicalStackKey(extractStack)) || (neededAmt = (long)filterCount - (currentAmt = chemicalStack.getAmount())) >= extractStack.getAmount()) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0L) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            long amtReturned = handler.insertChemical(extractStack, Action.SIMULATE).getAmount();
            if (amtReturned == amtToExtract) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtToExtract - amtReturned);
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.EXECUTE);
            if (drainedStack.isEmpty()) continue;
            foundAnything = true;
            handler.insertChemical(drainedStack, Action.EXECUTE);
            this.drawParticlesChemical(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0L) continue;
            return true;
        }
        return foundAnything;
    }

    public boolean extractChemicalStackExact(ExtractorCardCache extractorCardCache, IChemicalHandler fromInventory, ChemicalStack<?> extractStack, ChemicalType chemicalType) {
        long totalAmtNeeded = extractStack.getAmount();
        long amtToExtract = extractStack.getAmount();
        ChemicalStack testDrain = fromInventory.extractChemical(extractStack, Action.SIMULATE);
        if (testDrain.getAmount() < totalAmtNeeded) {
            return false;
        }
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.laserNodeBE.getRR(extractorCardCache);
            inserterCardCaches = this.laserNodeBE.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2LongOpenHashMap insertHandlers = new Object2LongOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeChemicalHandler laserNodeChemicalHandler = this.getLaserNodeHandlerChemical(inserterCardCache, chemicalType);
            if (laserNodeChemicalHandler == null) continue;
            IChemicalHandler<?, ?> handler = laserNodeChemicalHandler.handler;
            if (inserterCardCache.filterCard.m_41720_() instanceof FilterCount) {
                int filterCount = inserterCardCache.mekanismCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    long currentAmt;
                    long neededAmt;
                    ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                    if (!chemicalStack.isEmpty() && !new ChemicalStackKey(chemicalStack).equals(new ChemicalStackKey(extractStack)) || (neededAmt = (long)filterCount - (currentAmt = chemicalStack.getAmount())) >= totalAmtNeeded) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0L) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            long amtReturned = handler.insertChemical(extractStack, Action.SIMULATE).getAmount();
            if (amtReturned == amtToExtract) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtToExtract - amtReturned);
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.SIMULATE);
            if (drainedStack.isEmpty()) continue;
            insertHandlers.put(inserterCardCache, drainedStack.getAmount());
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0L) continue;
            break;
        }
        if (totalAmtNeeded > 0L) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeChemicalHandler laserNodeChemicalHandler = this.getLaserNodeHandlerChemical(inserterCardCache, chemicalType);
            IChemicalHandler<?, ?> handler = laserNodeChemicalHandler.handler;
            extractStack.setAmount(((Long)entry.getValue()).longValue());
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.EXECUTE);
            handler.insertChemical(drainedStack, Action.EXECUTE);
            this.drawParticlesChemical(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
        }
        return true;
    }

    public List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, ChemicalStack<?> stack) {
        ChemicalStackKey key = new ChemicalStackKey(stack);
        if (this.inserterCacheChemical.containsKey(extractorCardCache)) {
            if (this.inserterCacheChemical.get(extractorCardCache).containsKey(key)) {
                return this.inserterCacheChemical.get(extractorCardCache).get(key);
            }
            List<InserterCardCache> nodes = this.laserNodeBE.getInserterNodes().stream().filter(p -> p.channel == extractorCardCache.channel && p.cardType.equals((Object)extractorCardCache.cardType) && p.enabled && p.mekanismCardCache.isStackValidForCard(stack) && (!p.relativePos.blockPos.equals((Object)BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
            this.inserterCacheChemical.get(extractorCardCache).put(key, nodes);
            return nodes;
        }
        List<InserterCardCache> nodes = this.laserNodeBE.getInserterNodes().stream().filter(p -> p.channel == extractorCardCache.channel && p.cardType.equals((Object)extractorCardCache.cardType) && p.enabled && p.mekanismCardCache.isStackValidForCard(stack) && (!p.relativePos.blockPos.equals((Object)BlockPos.f_121853_) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
        HashMap<ChemicalStackKey, List<InserterCardCache>> tempMap = new HashMap<ChemicalStackKey, List<InserterCardCache>>();
        tempMap.put(key, nodes);
        this.inserterCacheChemical.put(extractorCardCache, tempMap);
        return nodes;
    }

    public LaserNodeChemicalHandler getLaserNodeHandlerChemical(InserterCardCache inserterCardCache, ChemicalType chemicalType) {
        if (inserterCardCache.cardType != BaseCard.CardType.CHEMICAL) {
            return null;
        }
        Level level = this.laserNodeBE.m_58904_();
        if (level == null) {
            return null;
        }
        Level targetLevel = inserterCardCache.relativePos.getLevel(level.m_7654_());
        if (targetLevel == null) {
            return null;
        }
        BlockPos nodeWorldPos = this.laserNodeBE.getWorldPos(inserterCardCache.relativePos.blockPos);
        DimBlockPos nodeDimWorldPos = new DimBlockPos(targetLevel, nodeWorldPos);
        if (!this.laserNodeBE.chunksLoaded(nodeDimWorldPos, nodeWorldPos.m_121945_(inserterCardCache.direction))) {
            return null;
        }
        LaserNodeBE be = this.laserNodeBE.getNodeAt(nodeDimWorldPos);
        if (be == null) {
            return null;
        }
        Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> chemicalHandlerMap = be.mekanismCache.getAttachedChemicalTanks(inserterCardCache.direction, inserterCardCache.sneaky);
        if (chemicalHandlerMap == null || !chemicalHandlerMap.containsKey(chemicalType)) {
            return null;
        }
        LazyOptional<IChemicalHandler<?, ?>> chemicalHandler = chemicalHandlerMap.get(chemicalType);
        if (!chemicalHandler.isPresent()) {
            return null;
        }
        IChemicalHandler handler = (IChemicalHandler)chemicalHandler.resolve().get();
        if (handler.getTanks() == 0) {
            return null;
        }
        return new LaserNodeChemicalHandler(be, handler);
    }

    private void addChemicalHandlerToMapGeneric(Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> map, LaserNodeBE.SideConnection sideConnection, BlockEntity be, Direction inventorySide, ChemicalType chemicalType) {
        LazyOptional chemicalHandlerOptional = be.getCapability(MekanismStatics.getCapabilityForChemical(chemicalType), inventorySide);
        if (chemicalHandlerOptional.isPresent()) {
            if (sideConnection != null) {
                chemicalHandlerOptional.addListener(this.getInvalidatorChemical(sideConnection, chemicalType));
            }
            map.put(chemicalType, chemicalHandlerOptional);
        }
    }

    private void addChemicalHandlerToMap(LaserNodeBE.SideConnection sideConnection, BlockEntity be, Direction inventorySide, ChemicalType chemicalType) {
        this.addChemicalHandlerToMapGeneric(this.facingHandlerChemical.get(sideConnection), sideConnection, be, inventorySide, chemicalType);
    }

    private void addChemicalHandlerToMapNoCache(Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> map, BlockEntity be, Direction inventorySide, ChemicalType chemicalType) {
        this.addChemicalHandlerToMapGeneric(map, null, be, inventorySide, chemicalType);
    }

    public Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> getAttachedChemicalTanks(Direction direction, Byte sneakySide) {
        LaserNodeBE.SideConnection sideConnection;
        Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> testHandlerMap;
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        if ((testHandlerMap = this.facingHandlerChemical.get(sideConnection = new LaserNodeBE.SideConnection(direction, inventorySide))) != null && !testHandlerMap.isEmpty()) {
            return testHandlerMap;
        }
        Level level = this.laserNodeBE.m_58904_();
        assert (level != null);
        BlockEntity be = level.m_7702_(this.laserNodeBE.m_58899_().m_121945_(direction));
        if (be != null) {
            if (testHandlerMap == null) {
                this.facingHandlerChemical.put(sideConnection, new HashMap());
            }
            for (ChemicalType chemicalType : ChemicalType.values()) {
                this.addChemicalHandlerToMap(sideConnection, be, inventorySide, chemicalType);
            }
            if (!this.facingHandlerChemical.get(sideConnection).isEmpty()) {
                return this.facingHandlerChemical.get(sideConnection);
            }
        }
        this.facingHandlerChemical.remove(sideConnection);
        return null;
    }

    public Map<ChemicalType, LazyOptional<IChemicalHandler<?, ?>>> getAttachedChemicalTanksNoCache(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.m_122424_();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        Level level = this.laserNodeBE.m_58904_();
        assert (level != null);
        BlockEntity be = level.m_7702_(this.laserNodeBE.m_58899_().m_121945_(direction));
        if (be != null) {
            HashMap returnMap = new HashMap();
            for (ChemicalType chemicalType : ChemicalType.values()) {
                this.addChemicalHandlerToMapNoCache(returnMap, be, inventorySide, chemicalType);
            }
            if (!returnMap.isEmpty()) {
                return returnMap;
            }
        }
        return null;
    }

    private NonNullConsumer<LazyOptional<IChemicalHandler<?, ?>>> getInvalidatorChemical(LaserNodeBE.SideConnection sideConnection, ChemicalType chemicalType) {
        if (this.connectionInvalidatorChemical.get(sideConnection) == null) {
            this.connectionInvalidatorChemical.put(sideConnection, new HashMap());
        }
        return this.connectionInvalidatorChemical.get(sideConnection).computeIfAbsent(chemicalType, c -> new WeakConsumerWrapper<MekanismCache, LazyOptional>(this, (te, handler) -> {
            if (te.facingHandlerChemical.get(sideConnection) != null && te.facingHandlerChemical.get(sideConnection).get(chemicalType) == handler) {
                this.laserNodeBE.clearCachedInventories(sideConnection, chemicalType);
            }
        }));
    }

    public void drawParticlesChemical(ChemicalStack<?> chemicalStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        if (!sourceBE.getShowParticles() || !destinationBE.getShowParticles()) {
            return;
        }
        ServerTickHandler.addToListChemical(new ParticleDataChemical(chemicalStack, new DimBlockPos(sourceBE.m_58904_(), sourceBE.m_58899_()), (byte)fromDirection.ordinal(), new DimBlockPos(destinationBE.m_58904_(), destinationBE.m_58899_()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void drawParticlesClient(ParticleRenderDataChemical partData) {
        Level level = this.laserNodeBE.m_58904_();
        ClientLevel clientLevel = (ClientLevel)level;
        ChemicalStack<?> chemicalStack = partData.chemicalStack;
        if (chemicalStack.isEmpty()) {
            return;
        }
        BlockPos toPos = partData.toPos;
        BlockPos fromPos = partData.fromPos;
        Direction direction = Direction.values()[partData.direction];
        BlockState targetState = level.m_8055_(toPos);
        float randomSpread = 0.01f;
        int min = 100;
        int max = 8000;
        int minPart = 8;
        int maxPart = 64;
        long count = (long)(maxPart - minPart) * (chemicalStack.getAmount() - (long)min) / (long)(max - min) + (long)minPart;
        if (targetState.m_60734_() instanceof LaserNode) {
            targetState = level.m_8055_(fromPos);
            VoxelShape voxelShape = targetState.m_60808_((BlockGetter)level, fromPos);
            Vector3f extractOffset = MiscTools.findOffset(direction, partData.position, LaserNodeBERender.OFFSETS);
            Vector3f insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, level, targetState);
            ChemicalFlowParticleData data = new ChemicalFlowParticleData(chemicalStack, (float)toPos.m_123341_() + extractOffset.x(), (float)toPos.m_123342_() + extractOffset.y(), (float)toPos.m_123343_() + extractOffset.z(), 10, chemicalStack.getType().toString());
            int i = 0;
            while ((long)i < count) {
                double d1 = this.random.nextGaussian() * (double)randomSpread;
                double d3 = this.random.nextGaussian() * (double)randomSpread;
                double d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.m_7106_((ParticleOptions)data, (double)((float)toPos.m_123341_() + insertOffset.x()) + d1, (double)((float)toPos.m_123342_() + insertOffset.y()) + d3, (double)((float)toPos.m_123343_() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                ++i;
            }
        } else {
            VoxelShape voxelShape = targetState.m_60808_((BlockGetter)level, toPos);
            Vector3f extractOffset = MiscTools.findOffset(direction, partData.position, LaserNodeBERender.OFFSETS);
            Vector3f insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, level, targetState);
            ChemicalFlowParticleData data = new ChemicalFlowParticleData(chemicalStack, (float)fromPos.m_123341_() + insertOffset.x(), (float)fromPos.m_123342_() + insertOffset.y(), (float)fromPos.m_123343_() + insertOffset.z(), 10, chemicalStack.getType().toString());
            int i = 0;
            while ((long)i < count) {
                double d1 = this.random.nextGaussian() * (double)randomSpread;
                double d3 = this.random.nextGaussian() * (double)randomSpread;
                double d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.m_7106_((ParticleOptions)data, (double)((float)fromPos.m_123341_() + extractOffset.x()) + d1, (double)((float)fromPos.m_123342_() + extractOffset.y()) + d3, (double)((float)fromPos.m_123343_() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    private record LaserNodeChemicalHandler(LaserNodeBE be, IChemicalHandler<?, ?> handler) {
    }
}

