/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen.loot;

import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import vazkii.patchouli.api.PatchouliAPI;

public class LaserIOAdvancementLootTables
implements LootTableSubProvider {
    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        HashSet registeredIds = new HashSet();
        this.generateAdvancementLootTables(lootTable -> {
            ResourceLocation id = lootTable.getId();
            if (!registeredIds.add(id)) {
                throw new IllegalStateException("Duplicate loot table " + id);
            }
            consumer.accept(id, lootTable.getBuilder());
        });
    }

    private void generateAdvancementLootTables(Consumer<LootTableWrapper> consumer) {
        ItemStack patchouliBook = PatchouliAPI.get().getBookStack(new ResourceLocation("laserio", "laseriobook"));
        LootTableWrapper.lootTable().withPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)patchouliBook.m_41720_()).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)patchouliBook.m_41784_())))).save(consumer, new ResourceLocation("laserio", "advancement_rewards/grant_book"));
    }

    public static class LootTableWrapper {
        private ResourceLocation id;
        private final LootTable.Builder builder = LootTable.m_79147_();

        public static LootTableWrapper lootTable() {
            return new LootTableWrapper();
        }

        private LootTableWrapper() {
        }

        public LootTableWrapper withPool(LootPool.Builder lootPool) {
            this.builder.m_79161_(lootPool);
            return this;
        }

        public void save(Consumer<LootTableWrapper> consumer, ResourceLocation id) {
            this.id = id;
            consumer.accept(this);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public LootTable.Builder getBuilder() {
            return this.builder;
        }
    }
}

