/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen.customrecipes;

import com.direwolf20.laserio.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CardClearRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;

    private CardClearRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static CardClearRecipeBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return new CardClearRecipeBuilder(category, result, count);
    }

    public static CardClearRecipeBuilder shapeless(RecipeCategory category, ItemLike result) {
        return new CardClearRecipeBuilder(category, result, 1);
    }

    public CardClearRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public CardClearRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public CardClearRecipeBuilder requires(TagKey<Item> tag, int quantity) {
        return this.requires(Ingredient.m_204132_(tag), quantity);
    }

    public CardClearRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(tag, 1);
    }

    public CardClearRecipeBuilder requires(ItemLike item, int quantity) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
    }

    public CardClearRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public CardClearRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(name, criterionTrigger);
        return this;
    }

    public CardClearRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    private void ensureValid(ResourceLocation consumer) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + consumer);
        }
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.result, this.count, this.group == null ? "" : this.group, CardClearRecipeBuilder.m_245179_((RecipeCategory)this.category), this.ingredients, this.advancement, id.m_246208_("recipes/misc/")));
    }

    public static class Result
    extends ShapelessRecipeBuilder.Result {
        public Result(ResourceLocation resourceLocation, Item result, int count, String group, CraftingBookCategory category, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(resourceLocation, result, count, group, category, ingredients, advancement, advancementId);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)Registration.CARD_CLEAR_RECIPE_SERIALIZER.get();
        }
    }
}

