/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen;

import com.direwolf20.laserio.setup.Registration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class LaserIOAdvancements
implements DataProvider,
IConditionBuilder {
    private final PackOutput.PathProvider pathProvider;

    public LaserIOAdvancements(PackOutput output) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashSet registeredIds = new HashSet();
        ArrayList futures = new ArrayList();
        this.generateConditionalAdvancements(advancement -> {
            ResourceLocation id = advancement.getId();
            if (!registeredIds.add(id)) {
                throw new IllegalStateException("Duplicate advancement " + id);
            }
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)advancement.serializeToJson(), (Path)this.pathProvider.m_245731_(id)));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private void generateConditionalAdvancements(Consumer<ConditionalAdvancementWrapper> consumer) {
        ConditionalAdvancementWrapper.builder().addCondition(this.modLoaded("patchouli")).addAdvancement(Advancement.Builder.m_138353_().m_138386_("obtain_laser_node", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registration.LASER_NODE_ITEM.get()})).m_138354_(AdvancementRewards.Builder.m_144822_((ResourceLocation)new ResourceLocation("laserio", "advancement_rewards/grant_book")))).save(consumer, new ResourceLocation("laserio", "grant_book"));
    }

    public String m_6055_() {
        return "LaserIO Advancements";
    }

    public static class ConditionalAdvancementWrapper {
        private ResourceLocation id;
        private final ConditionalAdvancement.Builder builder = ConditionalAdvancement.builder();

        public static ConditionalAdvancementWrapper builder() {
            return new ConditionalAdvancementWrapper();
        }

        private ConditionalAdvancementWrapper() {
        }

        public ConditionalAdvancementWrapper addCondition(ICondition condition) {
            this.builder.addCondition(condition);
            return this;
        }

        public ConditionalAdvancementWrapper addAdvancement(Advancement.Builder advancement) {
            this.builder.addAdvancement(advancement);
            return this;
        }

        public void save(Consumer<ConditionalAdvancementWrapper> consumer, ResourceLocation id) {
            this.id = id;
            consumer.accept(this);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public JsonObject serializeToJson() {
            return this.builder.write();
        }
    }
}

