/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateRedstoneCard {
    private byte mode;
    private byte channel;
    private boolean interval;
    private byte intervalLowerBound;
    private byte intervalUpperBound;
    private byte intervalOutput;
    private boolean strong;
    private byte outputMode;
    private byte logicOperation;
    private byte logicOperationChannel;

    public PacketUpdateRedstoneCard(byte mode, byte channel, boolean interval, byte intervalLowerBound, byte intervalUpperBound, byte intervalOutput, boolean strong, byte outputMode, byte logicOperation, byte logicOperationChannel) {
        this.mode = mode;
        this.channel = channel;
        this.strong = strong;
        this.interval = interval;
        this.intervalLowerBound = intervalLowerBound;
        this.intervalUpperBound = intervalUpperBound;
        this.intervalOutput = intervalOutput;
        this.outputMode = outputMode;
        this.logicOperation = logicOperation;
        this.logicOperationChannel = logicOperationChannel;
    }

    public static void encode(PacketUpdateRedstoneCard msg, FriendlyByteBuf buffer) {
        buffer.writeByte((int)msg.mode);
        buffer.writeByte((int)msg.channel);
        buffer.writeBoolean(msg.interval);
        buffer.writeByte((int)msg.intervalLowerBound);
        buffer.writeByte((int)msg.intervalUpperBound);
        buffer.writeByte((int)msg.intervalOutput);
        buffer.writeBoolean(msg.strong);
        buffer.writeByte((int)msg.outputMode);
        buffer.writeByte((int)msg.logicOperation);
        buffer.writeByte((int)msg.logicOperationChannel);
    }

    public static PacketUpdateRedstoneCard decode(FriendlyByteBuf buffer) {
        return new PacketUpdateRedstoneCard(buffer.readByte(), buffer.readByte(), buffer.readBoolean(), buffer.readByte(), buffer.readByte(), buffer.readByte(), buffer.readBoolean(), buffer.readByte(), buffer.readByte(), buffer.readByte());
    }

    public static class Handler {
        public static void handle(PacketUpdateRedstoneCard msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (!(container instanceof CardRedstoneContainer)) {
                    return;
                }
                ItemStack stack = ((CardRedstoneContainer)container).cardItem;
                CardRedstone.setTransferMode(stack, msg.mode);
                CardRedstone.setRedstoneChannel(stack, msg.channel);
                CardRedstone.setInterval(stack, msg.interval);
                CardRedstone.setIntervalLowerBound(stack, msg.intervalLowerBound);
                CardRedstone.setIntervalUpperBound(stack, msg.intervalUpperBound);
                CardRedstone.setIntervalOutput(stack, msg.intervalOutput);
                CardRedstone.setStrong(stack, msg.strong);
                CardRedstone.setOutputMode(stack, msg.outputMode);
                CardRedstone.setLogicOperation(stack, msg.logicOperation);
                CardRedstone.setRedstoneChannelOperation(stack, msg.logicOperationChannel);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

