/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateFilterTag {
    private boolean allowList;
    private List<String> tags;

    public PacketUpdateFilterTag(boolean allowList, List<String> tags) {
        this.allowList = allowList;
        this.tags = tags;
    }

    public static void encode(PacketUpdateFilterTag msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.allowList);
        buffer.m_236828_(msg.tags, FriendlyByteBuf::m_130070_);
    }

    public static PacketUpdateFilterTag decode(FriendlyByteBuf buffer) {
        return new PacketUpdateFilterTag(buffer.readBoolean(), (List)buffer.m_236838_(Lists::newArrayListWithCapacity, FriendlyByteBuf::m_130277_));
    }

    public static class Handler {
        public static void handle(PacketUpdateFilterTag msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                if (container instanceof FilterTagContainer) {
                    FilterTagContainer filterTagContainer = (FilterTagContainer)container;
                    ItemStack stack = filterTagContainer.filterItem;
                    FilterTag.setAllowList(stack, msg.allowList);
                    FilterTag.setTags(stack, msg.tags);
                } else if (container instanceof FilterNBTContainer) {
                    FilterNBTContainer filterNBTContainer = (FilterNBTContainer)container;
                    ItemStack stack = filterNBTContainer.filterItem;
                    FilterNBT.setAllowList(stack, msg.allowList);
                    FilterNBT.setTags(stack, msg.tags);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

