/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardChemicalContainer;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.CardFluidContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.CardItemHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.network.packets.PacketOpenFilter;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketOpenCard {
    private int slotNumber;
    private BlockPos sourcePos;
    private boolean hasShiftDown;

    public PacketOpenCard(int slotNumber, BlockPos pos, boolean hasShiftDown) {
        this.slotNumber = slotNumber;
        this.sourcePos = pos;
        this.hasShiftDown = hasShiftDown;
    }

    public static void encode(PacketOpenCard msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slotNumber);
        buffer.m_130064_(msg.sourcePos);
        buffer.writeBoolean(msg.hasShiftDown);
    }

    public static PacketOpenCard decode(FriendlyByteBuf buffer) {
        return new PacketOpenCard(buffer.readInt(), buffer.m_130135_(), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketOpenCard msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                byte side;
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                Slot slot = (Slot)container.f_38839_.get(msg.slotNumber);
                ItemStack itemStack = slot.m_7993_();
                CardItemHandler handler = BaseCard.getInventory(itemStack);
                if (container instanceof LaserNodeContainer) {
                    LaserNodeContainer nodeContainer = (LaserNodeContainer)container;
                    v0 = nodeContainer.side;
                } else {
                    v0 = side = -1;
                }
                if (itemStack.m_41720_() instanceof CardItem) {
                    if (!msg.hasShiftDown) {
                        NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardItemContainer(windowId, playerInventory, (Player)sender, msg.sourcePos, itemStack, side), (Component)Component.m_237115_((String)"")), buf -> {
                            buf.m_130055_(itemStack);
                            buf.writeByte((int)side);
                        });
                    } else {
                        filterItem = handler.getStackInSlot(0);
                        if (filterItem.m_41720_() instanceof BaseFilter) {
                            PacketOpenFilter.doOpenFilter(filterItem, itemStack, sender, msg.sourcePos);
                        }
                    }
                } else if (itemStack.m_41720_() instanceof CardFluid) {
                    if (!msg.hasShiftDown) {
                        NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardFluidContainer(windowId, playerInventory, (Player)sender, msg.sourcePos, itemStack, side), (Component)Component.m_237115_((String)"")), buf -> {
                            buf.m_130055_(itemStack);
                            buf.writeByte((int)side);
                        });
                    } else {
                        filterItem = handler.getStackInSlot(0);
                        if (filterItem.m_41720_() instanceof BaseFilter) {
                            PacketOpenFilter.doOpenFilter(filterItem, itemStack, sender, msg.sourcePos);
                        }
                    }
                } else if (itemStack.m_41720_() instanceof CardEnergy) {
                    NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardEnergyContainer(windowId, playerInventory, (Player)sender, msg.sourcePos, itemStack, side), (Component)Component.m_237115_((String)"")), buf -> {
                        buf.m_130055_(itemStack);
                        buf.writeByte((int)side);
                    });
                } else if (itemStack.m_41720_() instanceof CardRedstone) {
                    NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardRedstoneContainer(windowId, playerInventory, (Player)sender, msg.sourcePos, itemStack, side), (Component)Component.m_237115_((String)"")), buf -> {
                        buf.m_130055_(itemStack);
                        buf.writeByte((int)side);
                    });
                } else if (itemStack.m_41720_() instanceof CardChemical) {
                    if (!msg.hasShiftDown) {
                        NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardChemicalContainer(windowId, playerInventory, (Player)sender, msg.sourcePos, itemStack, side), (Component)Component.m_237115_((String)"")), buf -> {
                            buf.m_130055_(itemStack);
                            buf.writeByte((int)side);
                        });
                    } else {
                        filterItem = handler.getStackInSlot(0);
                        if (filterItem.m_41720_() instanceof BaseFilter) {
                            PacketOpenFilter.doOpenFilter(filterItem, itemStack, sender, msg.sourcePos);
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

