/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleDataChemical;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleRenderDataChemical;
import com.direwolf20.laserio.util.DimBlockPos;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketNodeParticlesChemical {
    private List<ParticleDataChemical> particleList;

    public PacketNodeParticlesChemical(List<ParticleDataChemical> particleList) {
        this.particleList = particleList;
    }

    public static void encode(PacketNodeParticlesChemical msg, FriendlyByteBuf buffer) {
        List<ParticleDataChemical> tempList = msg.particleList;
        int size = tempList.size();
        buffer.writeInt(size);
        for (ParticleDataChemical data : tempList) {
            buffer.m_130070_(data.chemicalType);
            ChemicalUtils.writeChemicalStack((FriendlyByteBuf)buffer, data.chemicalStack);
            if (data.fromData != null) {
                buffer.m_236858_(data.fromData.node().levelKey);
                buffer.m_130064_(data.fromData.node().blockPos);
                buffer.writeByte((int)data.fromData.direction());
                buffer.writeByte((int)data.fromData.position());
            }
            if (data.toData == null) continue;
            buffer.m_236858_(data.toData.node().levelKey);
            buffer.m_130064_(data.toData.node().blockPos);
            buffer.writeByte((int)data.toData.direction());
            buffer.writeByte((int)data.toData.position());
        }
    }

    public static PacketNodeParticlesChemical decode(FriendlyByteBuf buffer) {
        ArrayList<ParticleDataChemical> thisList = new ArrayList<ParticleDataChemical>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            GasStack chemicalStack;
            String type = buffer.m_130277_();
            ChemicalType chemicalType = ChemicalType.fromString((String)type);
            switch (chemicalType) {
                case GAS: {
                    GasStack gasStack = ChemicalUtils.readGasStack((FriendlyByteBuf)buffer);
                    break;
                }
                case INFUSION: {
                    GasStack gasStack = ChemicalUtils.readInfusionStack((FriendlyByteBuf)buffer);
                    break;
                }
                case PIGMENT: {
                    GasStack gasStack = ChemicalUtils.readPigmentStack((FriendlyByteBuf)buffer);
                    break;
                }
                case SLURRY: {
                    GasStack gasStack = ChemicalUtils.readSlurryStack((FriendlyByteBuf)buffer);
                    break;
                }
                default: {
                    GasStack gasStack = chemicalStack = null;
                }
            }
            if (chemicalStack == null) continue;
            DimBlockPos fromNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte fromDirection = buffer.readByte();
            byte extractPosition = buffer.readByte();
            DimBlockPos toNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte toDirection = buffer.readByte();
            byte insertPosition = buffer.readByte();
            ParticleDataChemical data = new ParticleDataChemical((ChemicalStack<?>)chemicalStack, fromNode, fromDirection, toNode, toDirection, extractPosition, insertPosition);
            thisList.add(data);
        }
        return new PacketNodeParticlesChemical(thisList);
    }

    public static void clientPacketHandler(PacketNodeParticlesChemical msg) {
        List<ParticleDataChemical> tempList = msg.particleList;
        for (ParticleDataChemical data : tempList) {
            if (data.fromData != null) {
                DimBlockPos fromPos = data.fromData.node();
                BlockEntity fromBE = Minecraft.m_91087_().f_91073_.m_7702_(fromPos.blockPos);
                if (fromBE instanceof LaserNodeBE) {
                    LaserNodeBE fromNodeBE = (LaserNodeBE)fromBE;
                    fromNodeBE.addParticleDataChemical(new ParticleRenderDataChemical(data.chemicalStack, fromPos.blockPos.m_121945_(Direction.values()[data.fromData.direction()]), data.fromData.direction(), data.fromData.node().blockPos, data.fromData.position()));
                }
            }
            if (data.toData == null) continue;
            DimBlockPos toPos = data.toData.node();
            BlockEntity toBE = Minecraft.m_91087_().f_91073_.m_7702_(toPos.blockPos);
            if (!(toBE instanceof LaserNodeBE)) continue;
            LaserNodeBE toNodeBE = (LaserNodeBE)toBE;
            toNodeBE.addParticleDataChemical(new ParticleRenderDataChemical(data.chemicalStack, data.toData.node().blockPos, data.toData.direction(), toPos.blockPos.m_121945_(Direction.values()[data.toData.direction()]), data.toData.position()));
        }
    }

    public static class Handler {
        public static void handle(PacketNodeParticlesChemical msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketNodeParticlesChemical.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

