/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleRenderData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketNodeParticles {
    private List<ParticleData> particleList;

    public PacketNodeParticles(List<ParticleData> particleList) {
        this.particleList = particleList;
    }

    public static void encode(PacketNodeParticles msg, FriendlyByteBuf buffer) {
        List<ParticleData> tempList = msg.particleList;
        int size = tempList.size();
        buffer.writeInt(size);
        for (ParticleData data : tempList) {
            buffer.writeInt(data.item);
            buffer.writeByte((int)data.itemCount);
            if (data.fromData != null) {
                buffer.m_236858_(data.fromData.node().levelKey);
                buffer.m_130064_(data.fromData.node().blockPos);
                buffer.writeByte((int)data.fromData.direction());
                buffer.writeByte((int)data.fromData.position());
            }
            if (data.toData == null) continue;
            buffer.m_236858_(data.toData.node().levelKey);
            buffer.m_130064_(data.toData.node().blockPos);
            buffer.writeByte((int)data.toData.direction());
            buffer.writeByte((int)data.toData.position());
        }
    }

    public static PacketNodeParticles decode(FriendlyByteBuf buffer) {
        ArrayList<ParticleData> thisList = new ArrayList<ParticleData>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int item = buffer.readInt();
            byte itemCount = buffer.readByte();
            DimBlockPos fromNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte fromDirection = buffer.readByte();
            byte extractPosition = buffer.readByte();
            DimBlockPos toNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte toDirection = buffer.readByte();
            byte insertPosition = buffer.readByte();
            ParticleData data = new ParticleData(item, itemCount, fromNode, fromDirection, toNode, toDirection, extractPosition, insertPosition);
            thisList.add(data);
        }
        return new PacketNodeParticles(thisList);
    }

    public static void clientPacketHandler(PacketNodeParticles msg) {
        List<ParticleData> tempList = msg.particleList;
        for (ParticleData data : tempList) {
            if (data.fromData != null) {
                DimBlockPos fromPos = data.fromData.node();
                BlockEntity fromBE = Minecraft.m_91087_().f_91073_.m_7702_(fromPos.blockPos);
                if (fromBE instanceof LaserNodeBE) {
                    LaserNodeBE fromNodeBE = (LaserNodeBE)fromBE;
                    fromNodeBE.addParticleData(new ParticleRenderData(data.item, data.itemCount, fromPos.blockPos.m_121945_(Direction.values()[data.fromData.direction()]), data.fromData.direction(), data.fromData.node().blockPos, data.fromData.position()));
                }
            }
            if (data.toData == null) continue;
            DimBlockPos toPos = data.toData.node();
            BlockEntity toBE = Minecraft.m_91087_().f_91073_.m_7702_(toPos.blockPos);
            if (!(toBE instanceof LaserNodeBE)) continue;
            LaserNodeBE toNodeBE = (LaserNodeBE)toBE;
            toNodeBE.addParticleData(new ParticleRenderData(data.item, data.itemCount, data.toData.node().blockPos, data.toData.direction(), toPos.blockPos.m_121945_(Direction.values()[data.toData.direction()]), data.toData.position()));
        }
    }

    public static class Handler {
        public static void handle(PacketNodeParticles msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketNodeParticles.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

