/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardChemicalContainer;
import com.direwolf20.laserio.common.containers.CardFluidContainer;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketGhostSlot {
    private int slotNumber;
    private ItemStack stack;
    private int count;
    private int mbAmt;

    public PacketGhostSlot(int slotNumber, ItemStack stack, int count) {
        this(slotNumber, stack, count, -1);
    }

    public PacketGhostSlot(int slotNumber, ItemStack stack, int count, int mbAmt) {
        this.slotNumber = slotNumber;
        this.stack = stack;
        this.count = count;
        this.mbAmt = mbAmt;
    }

    public static void encode(PacketGhostSlot msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slotNumber);
        buffer.m_130055_(msg.stack);
        buffer.writeInt(msg.count);
        buffer.writeInt(msg.mbAmt);
    }

    public static PacketGhostSlot decode(FriendlyByteBuf buffer) {
        return new PacketGhostSlot(buffer.readInt(), buffer.m_130267_(), buffer.readInt(), buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketGhostSlot msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                ItemStack filterStack = ((Slot)container.f_38839_.get(0)).m_7993_();
                if (container instanceof CardItemContainer) {
                    CardItemContainer cardItemContainer = (CardItemContainer)container;
                    if (filterStack.m_41720_() instanceof FilterCount) {
                        ItemStack stack = msg.stack;
                        FilterCountHandler handler = (FilterCountHandler)cardItemContainer.filterHandler;
                        int mbAmt = msg.mbAmt;
                        if (mbAmt == 0 && (container instanceof CardFluidContainer || container instanceof CardChemicalContainer)) {
                            stack.m_41764_(0);
                        } else {
                            stack.m_41764_(msg.count);
                        }
                        handler.setStackInSlotSave(msg.slotNumber - 2, stack);
                        if (mbAmt == -1) return;
                        if (!(container instanceof CardFluidContainer)) {
                            if (!(container instanceof CardChemicalContainer)) return;
                        }
                        handler.setMBAmountInSlot(msg.slotNumber - 2, mbAmt);
                        return;
                    }
                }
                if (container instanceof FilterCountContainer) {
                    FilterCountContainer filterCountContainer = (FilterCountContainer)container;
                    ItemStack stack = msg.stack;
                    stack.m_41764_(msg.count);
                    FilterCountHandler handler = filterCountContainer.handler;
                    handler.setStackInSlotSave(msg.slotNumber, stack);
                    return;
                }
                Slot slot = (Slot)container.f_38839_.get(msg.slotNumber);
                ItemStack stack = msg.stack;
                stack.m_41764_(msg.count);
                if (!(slot instanceof FilterBasicSlot)) return;
                slot.m_5852_(stack);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

