/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.util.SoundUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketCopyPasteCard {
    private int slot;
    private boolean copy;

    public PacketCopyPasteCard(int slot, boolean copy) {
        this.slot = slot;
        this.copy = copy;
    }

    public static void encode(PacketCopyPasteCard msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slot);
        buffer.writeBoolean(msg.copy);
    }

    public static PacketCopyPasteCard decode(FriendlyByteBuf buffer) {
        return new PacketCopyPasteCard(buffer.readInt(), buffer.readBoolean());
    }

    public static int returnItemToHolder(LaserNodeContainer container, ItemStack returnStack, boolean simulate) {
        int returnCount = returnStack.m_41613_();
        if (returnCount == 0) {
            return 0;
        }
        if (container.cardHolder.m_41619_()) {
            return returnCount;
        }
        HashMap<Integer, Integer> returnStackMap = new HashMap<Integer, Integer>();
        for (int returnSlot = 10; returnSlot < 25; ++returnSlot) {
            ItemStack possibleReturnStack = container.m_38853_(returnSlot).m_7993_();
            if (!possibleReturnStack.m_41619_() && (!possibleReturnStack.m_150930_(returnStack.m_41720_()) || possibleReturnStack.m_41613_() >= possibleReturnStack.m_41741_())) continue;
            int roomAvailable = possibleReturnStack.m_41741_() - possibleReturnStack.m_41613_();
            int amtFit = Math.min(returnCount, roomAvailable);
            returnStackMap.put(returnSlot, amtFit);
            if ((returnCount -= amtFit) == 0) break;
        }
        if (simulate) {
            return returnCount;
        }
        for (Map.Entry entry : returnStackMap.entrySet()) {
            ItemStack possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            if (possibleReturnStack.m_41619_()) {
                container.m_38853_((Integer)entry.getKey()).m_5852_(returnStack);
                possibleReturnStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
                possibleReturnStack.m_41764_(((Integer)entry.getValue()).intValue());
                continue;
            }
            possibleReturnStack.m_41769_(((Integer)entry.getValue()).intValue());
        }
        return returnCount;
    }

    public static boolean getItemFromHolder(LaserNodeContainer container, ItemStack neededStack, boolean simulate) {
        int neededCount = neededStack.m_41613_();
        if (neededCount == 0) {
            return true;
        }
        if (container.cardHolder.m_41619_()) {
            return false;
        }
        Item neededItem = neededStack.m_41720_();
        HashMap<Integer, Integer> foundStackMap = new HashMap<Integer, Integer>();
        for (int slot = 10; slot < 25; ++slot) {
            ItemStack possibleStack = container.m_38853_(slot).m_7993_();
            boolean possibleStackMatches = neededItem instanceof BaseCard ? ItemStack.m_150942_((ItemStack)possibleStack, (ItemStack)neededStack) : possibleStack.m_150930_(neededItem);
            if (!possibleStackMatches) continue;
            int stackAvailable = possibleStack.m_41613_();
            int amtFound = Math.min(neededCount, stackAvailable);
            foundStackMap.put(slot, amtFound);
            if ((neededCount -= amtFound) != 0) continue;
            if (!simulate) break;
            return true;
        }
        if (neededCount > 0) {
            return false;
        }
        for (Map.Entry entry : foundStackMap.entrySet()) {
            ItemStack foundStack = container.m_38853_((Integer)entry.getKey()).m_7993_();
            foundStack.m_41774_(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    public static ItemStack searchCardInHolder(LaserNodeContainer container, String neededCardType) {
        if (container.cardHolder.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (int slot = 10; slot < 25; ++slot) {
            ItemStack possibleCard = container.m_38853_(slot).m_7993_();
            if (!possibleCard.m_41720_().toString().equals(neededCardType)) continue;
            return possibleCard.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    public static class Handler {
        public static void handle(PacketCopyPasteCard msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (!(container instanceof LaserNodeContainer)) {
                    return;
                }
                LaserNodeContainer nodeContainer = (LaserNodeContainer)container;
                ItemStack clonerStack = nodeContainer.m_142621_();
                if (!(clonerStack.m_41720_() instanceof CardCloner)) {
                    return;
                }
                Slot nodeSlot = nodeContainer.m_38853_(msg.slot);
                ItemStack slotStack = nodeSlot.m_7993_();
                if (msg.copy) {
                    Item slotItem = slotStack.m_41720_();
                    if (slotItem instanceof BaseCard) {
                        CardCloner.setItemType(clonerStack, slotItem.toString());
                        CompoundTag settingsTag = slotStack.m_41783_() == null ? new CompoundTag() : slotStack.m_41783_();
                        CardCloner.setSettings(clonerStack, settingsTag);
                        SoundUtil.playSound(sender, SoundEvents.f_12493_);
                    } else {
                        SoundUtil.playSound(sender, SoundEvents.f_276627_);
                    }
                } else {
                    boolean successfullyPasted = false;
                    String copiedCardType = CardCloner.getItemType(clonerStack);
                    if (!copiedCardType.isBlank()) {
                        Item slotItem;
                        boolean cardFromHolder = false;
                        if (slotStack.m_41619_()) {
                            slotStack = PacketCopyPasteCard.searchCardInHolder(nodeContainer, copiedCardType);
                            cardFromHolder = true;
                        }
                        if ((slotItem = slotStack.m_41720_()).toString().equals(copiedCardType)) {
                            ItemStack neededStack;
                            ItemStack neededFilter = CardCloner.getCopiedCardFilter(clonerStack);
                            ItemStack neededOverclockers = CardCloner.getCopiedCardOverclocker(clonerStack);
                            ItemStack existingFilter = ItemStack.f_41583_;
                            ItemStack existingOverclockers = ItemStack.f_41583_;
                            if (slotItem instanceof CardEnergy && CardEnergyContainer.SLOTS == 1) {
                                cardItemHandler = CardEnergy.getInventory(slotStack);
                                existingOverclockers = cardItemHandler.getStackInSlot(0);
                            } else if (!(slotItem instanceof CardRedstone)) {
                                cardItemHandler = BaseCard.getInventory(slotStack);
                                existingFilter = cardItemHandler.getStackInSlot(0);
                                existingOverclockers = cardItemHandler.getStackInSlot(1);
                            }
                            boolean filterSatisfied = true;
                            if (!existingFilter.m_150930_(neededFilter.m_41720_())) {
                                filterSatisfied = PacketCopyPasteCard.getItemFromHolder(nodeContainer, neededFilter, true);
                            }
                            int returnAmt = 0;
                            int neededAmt = 0;
                            if (!existingOverclockers.m_150930_(neededOverclockers.m_41720_())) {
                                returnAmt = existingOverclockers.m_41613_();
                                neededAmt = neededOverclockers.m_41613_();
                            } else {
                                int amt = existingOverclockers.m_41613_() - neededOverclockers.m_41613_();
                                if (amt > 0) {
                                    returnAmt = amt;
                                } else {
                                    neededAmt = -amt;
                                }
                            }
                            boolean overclockSatisfied = true;
                            if (neededAmt > 0) {
                                neededStack = new ItemStack((ItemLike)neededOverclockers.m_41720_(), neededAmt);
                                overclockSatisfied = PacketCopyPasteCard.getItemFromHolder(nodeContainer, neededStack, true);
                            }
                            if (filterSatisfied && overclockSatisfied) {
                                ItemStack returnStack;
                                int remaining;
                                if (cardFromHolder) {
                                    PacketCopyPasteCard.getItemFromHolder(nodeContainer, slotStack, false);
                                }
                                if (!existingFilter.m_150930_(neededFilter.m_41720_())) {
                                    if (PacketCopyPasteCard.returnItemToHolder(nodeContainer, existingFilter, false) != 0) {
                                        ItemEntity itemEntity = new ItemEntity(sender.m_9236_(), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), existingFilter);
                                        sender.m_9236_().m_7967_((Entity)itemEntity);
                                    }
                                    PacketCopyPasteCard.getItemFromHolder(nodeContainer, neededFilter, false);
                                }
                                if (returnAmt > 0 && (remaining = PacketCopyPasteCard.returnItemToHolder(nodeContainer, returnStack = new ItemStack((ItemLike)existingOverclockers.m_41720_(), returnAmt), false)) > 0) {
                                    returnStack.m_41764_(remaining);
                                    ItemEntity itemEntity = new ItemEntity(sender.m_9236_(), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), returnStack);
                                    sender.m_9236_().m_7967_((Entity)itemEntity);
                                }
                                if (neededAmt > 0) {
                                    neededStack = new ItemStack((ItemLike)neededOverclockers.m_41720_(), neededAmt);
                                    PacketCopyPasteCard.getItemFromHolder(nodeContainer, neededStack, false);
                                }
                                ItemStack tempStack = slotStack.m_41777_();
                                CompoundTag settingsTag = CardCloner.getSettings(clonerStack);
                                if (settingsTag.m_128456_()) {
                                    tempStack.m_41751_(null);
                                } else {
                                    tempStack.m_41751_(settingsTag.m_6426_());
                                }
                                nodeSlot.m_5852_(tempStack);
                                nodeContainer.tile.updateThisNode();
                                successfullyPasted = true;
                            }
                        }
                    }
                    if (successfullyPasted) {
                        SoundUtil.playSound(sender, SoundEvents.f_11887_);
                    } else {
                        SoundUtil.playSound(sender, SoundEvents.f_276627_);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

