/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class CardRedstone
extends BaseCard {
    public CardRedstone() {
        this.CARDTYPE = BaseCard.CardType.REDSTONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack card = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)card);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardRedstoneContainer(windowId, playerInventory, player, card), (Component)Component.m_237115_((String)"")), buf -> {
            buf.m_130055_(card);
            buf.writeByte(-1);
        });
        return InteractionResultHolder.m_19098_((Object)card);
    }

    public static byte nextTransferMode(ItemStack card) {
        byte mode = CardRedstone.getTransferMode(card);
        return CardRedstone.setTransferMode(card, (byte)(mode == 1 ? 0 : mode + 1));
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    @MigrateThresholdToInterval
    private static boolean migrateThresholdToInterval(ItemStack card, CompoundTag compound) {
        if (compound == null || !compound.m_128441_("redstonethreshold")) {
            return false;
        }
        boolean threshold = compound.m_128471_("redstonethreshold");
        card.m_41749_("redstonethreshold");
        card.m_41784_().m_128379_("redstoneinterval", threshold);
        return threshold;
    }

    public static boolean getInterval(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneinterval")) {
            return CardRedstone.migrateThresholdToInterval(card, compound);
        }
        return compound.m_128471_("redstoneinterval");
    }

    public static boolean setInterval(ItemStack card, boolean interval) {
        if (!interval) {
            card.m_41749_("redstoneinterval");
        } else {
            card.m_41784_().m_128379_("redstoneinterval", interval);
        }
        return interval;
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    @MigrateThresholdToInterval
    private static byte migrateThresholdLimitToIntervalLowerBound(ItemStack card, CompoundTag compound) {
        if (compound == null || !compound.m_128441_("redstonethresholdlimit")) {
            return 0;
        }
        byte thresholdLimit = compound.m_128445_("redstonethresholdlimit");
        card.m_41749_("redstonethresholdlimit");
        card.m_41784_().m_128344_("redstoneintervallowerbound", thresholdLimit);
        return thresholdLimit;
    }

    public static byte getIntervalLowerBound(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneintervallowerbound")) {
            return CardRedstone.migrateThresholdLimitToIntervalLowerBound(card, compound);
        }
        return compound.m_128445_("redstoneintervallowerbound");
    }

    public static byte setIntervalLowerBound(ItemStack card, byte intervalLowerBound) {
        if (intervalLowerBound == 0) {
            card.m_41749_("redstoneintervallowerbound");
        } else {
            card.m_41784_().m_128344_("redstoneintervallowerbound", intervalLowerBound);
        }
        return intervalLowerBound;
    }

    public static byte getIntervalUpperBound(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneintervalupperbound")) {
            return 15;
        }
        return compound.m_128445_("redstoneintervalupperbound");
    }

    public static byte setIntervalUpperBound(ItemStack card, byte intervalUpperBound) {
        if (intervalUpperBound == 15) {
            card.m_41749_("redstoneintervalupperbound");
        } else {
            card.m_41784_().m_128344_("redstoneintervalupperbound", intervalUpperBound);
        }
        return intervalUpperBound;
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    @MigrateThresholdToInterval
    private static byte migrateThresholdOutputToIntervalOutput(ItemStack card, CompoundTag compound) {
        if (compound == null || !compound.m_128441_("redstonethresholdoutput")) {
            return 15;
        }
        byte thresholdOutput = compound.m_128445_("redstonethresholdoutput");
        card.m_41749_("redstonethresholdoutput");
        card.m_41784_().m_128344_("redstoneintervaloutput", thresholdOutput);
        return thresholdOutput;
    }

    public static byte getIntervalOutput(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneintervaloutput")) {
            return CardRedstone.migrateThresholdOutputToIntervalOutput(card, compound);
        }
        return compound.m_128445_("redstoneintervaloutput");
    }

    public static byte setIntervalOutput(ItemStack card, byte intervalOutput) {
        if (intervalOutput == 15) {
            card.m_41749_("redstoneintervaloutput");
        } else {
            card.m_41784_().m_128344_("redstoneintervaloutput", intervalOutput);
        }
        return intervalOutput;
    }

    public static boolean getStrong(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("redstonestrong")) {
            return false;
        }
        return compound.m_128471_("redstonestrong");
    }

    public static boolean setStrong(ItemStack stack, boolean strong) {
        if (!strong) {
            stack.m_41749_("redstonestrong");
        } else {
            stack.m_41784_().m_128379_("redstonestrong", strong);
        }
        return strong;
    }

    public static byte getOutputMode(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("redstoneoutputmode")) {
            return 0;
        }
        return compound.m_128445_("redstoneoutputmode");
    }

    public static byte setOutputMode(ItemStack stack, byte outputMode) {
        if (outputMode == 0) {
            stack.m_41749_("redstoneoutputmode");
        } else {
            stack.m_41784_().m_128344_("redstoneoutputmode", outputMode);
        }
        return outputMode;
    }

    public static byte getLogicOperation(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstonelogicoperation")) {
            return 0;
        }
        return compound.m_128445_("redstonelogicoperation");
    }

    public static byte setLogicOperation(ItemStack card, byte logicOperation) {
        if (logicOperation == 0) {
            card.m_41749_("redstonelogicoperation");
        } else {
            card.m_41784_().m_128344_("redstonelogicoperation", logicOperation);
        }
        return logicOperation;
    }

    public static byte getRedstoneChannelOperation(ItemStack card) {
        CompoundTag compound = card.m_41783_();
        if (compound == null || !compound.m_128441_("redstonechanneloperation")) {
            return 0;
        }
        return compound.m_128445_("redstonechanneloperation");
    }

    public static byte setRedstoneChannelOperation(ItemStack card, byte logicOperationChannel) {
        if (logicOperationChannel == 0) {
            card.m_41749_("redstonechanneloperation");
        } else {
            card.m_41784_().m_128344_("redstonechanneloperation", logicOperationChannel);
        }
        return logicOperationChannel;
    }

    public static byte nextRedstoneChannelOperation(ItemStack card) {
        byte k = CardRedstone.getRedstoneChannelOperation(card);
        return CardRedstone.setRedstoneChannelOperation(card, (byte)(k == 15 ? 0 : k + 1));
    }

    public static byte previousRedstoneChannelOperation(ItemStack card) {
        byte k = CardRedstone.getRedstoneChannelOperation(card);
        return CardRedstone.setRedstoneChannelOperation(card, (byte)(k == 0 ? 15 : k - 1));
    }

    @Target(value={ElementType.METHOD})
    private static @interface MigrateThresholdToInterval {
    }
}

