/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.VectorHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserWrench
extends Item {
    public static final BlockPos NULL_CONNECTION_POS = new BlockPos(0, -1000, 0);

    public LaserWrench() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level targetDim, Player player, InteractionHand hand) {
        ItemStack wrench = player.m_21120_(hand);
        if (targetDim.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)wrench);
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, (int)((Integer)Config.MAX_INTERACTION_RANGE.get()));
        if (lookingAt == null || !(targetDim.m_8055_(lookingAt.m_82425_()).m_60734_() instanceof BaseLaserBlock)) {
            if (player.m_6144_()) {
                LaserWrench.storeConnectionPos(wrench, targetDim, NULL_CONNECTION_POS);
            }
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        BlockPos targetPos = lookingAt.m_82425_();
        BlockEntity targetBE = targetDim.m_7702_(targetPos);
        if (!(targetBE instanceof BaseLaserBE)) {
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        DimBlockPos sourceDimPos = LaserWrench.getConnectionPos(wrench, targetDim);
        Level sourceDim = sourceDimPos.getLevel(targetDim.m_7654_());
        BlockPos sourcePos = sourceDimPos.blockPos;
        if (player.m_6144_()) {
            if (targetPos.equals((Object)sourcePos) && targetDim.equals(sourceDim)) {
                LaserWrench.storeConnectionPos(wrench, targetDim, NULL_CONNECTION_POS);
            } else {
                LaserWrench.storeConnectionPos(wrench, targetDim, targetPos);
            }
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        if (targetPos.equals((Object)sourcePos) && targetDim.equals(sourceDim)) {
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        BlockEntity sourceBE = sourceDim.m_7702_(sourcePos);
        if (!(sourceBE instanceof BaseLaserBE)) {
            LaserWrench.storeConnectionPos(wrench, targetDim, NULL_CONNECTION_POS);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        if (targetBE instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE targetAdv = (LaserConnectorAdvBE)targetBE;
            if (sourceBE instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE sourceAdv = (LaserConnectorAdvBE)sourceBE;
                targetAdv.handleAdvancedConnection(sourceAdv);
                return InteractionResultHolder.m_19090_((Object)wrench);
            }
        }
        if (!targetPos.m_123314_((Vec3i)sourcePos, (double)((Integer)Config.MAX_NODES_DISTANCE.get()).intValue()) || !targetDim.equals(sourceDim)) {
            player.m_5661_((Component)Component.m_237110_((String)"message.laserio.laser_wrench.exceeded_maximum_connection_range", (Object[])new Object[]{Config.MAX_NODES_DISTANCE.get()}), true);
            return InteractionResultHolder.m_19098_((Object)wrench);
        }
        ((BaseLaserBE)targetBE).handleConnection((BaseLaserBE)sourceBE);
        return InteractionResultHolder.m_19090_((Object)wrench);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.show_details", ChatFormatting.GRAY));
        } else {
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.laser_wrench.select_node", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.shift_right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.laser_wrench.connect_node", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.laser_wrench.autoconnect_node", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.laser_wrench.autoconnect_node.keys", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
        }
    }

    public static DimBlockPos storeConnectionPos(ItemStack wrench, Level level, BlockPos pos) {
        DimBlockPos dimBlockPos = new DimBlockPos(level, pos);
        wrench.m_41784_().m_128365_("connectiondimpos", (Tag)dimBlockPos.toNBT());
        return dimBlockPos;
    }

    public static DimBlockPos getConnectionPos(ItemStack wrench, Level level) {
        CompoundTag compound = wrench.m_41784_();
        if (level == null) {
            return null;
        }
        return !compound.m_128441_("connectiondimpos") ? LaserWrench.storeConnectionPos(wrench, level, NULL_CONNECTION_POS) : new DimBlockPos(compound.m_128469_("connectiondimpos"));
    }
}

