/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.util.ItemHandlerUtil;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.SoundUtil;
import com.direwolf20.laserio.util.VectorHelper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CardCloner
extends Item {
    public static final MutableComponent[] PASTE_MODE_MESSAGES = new MutableComponent[]{Component.m_237115_((String)"message.laserio.card_cloner.paste_mode").m_7220_((Component)Component.m_237115_((String)"message.laserio.card_cloner.paste_mode.node_contents")), Component.m_237115_((String)"message.laserio.card_cloner.paste_mode").m_7220_((Component)Component.m_237115_((String)"message.laserio.card_cloner.paste_mode.network_settings"))};

    public CardCloner() {
        super(new Item.Properties().m_41487_(1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack cardCloner = player.m_21120_(hand);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, (int)((Integer)Config.MAX_INTERACTION_RANGE.get()));
        if (lookingAt == null || !(level.m_8055_(lookingAt.m_82425_()).m_60734_() instanceof LaserNode)) {
            if (level.m_5776_()) {
                if (player.m_6144_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.stored_settings_cleared"), true);
                    player.m_216990_(SoundEvents.f_11778_);
                    return InteractionResultHolder.m_19098_((Object)cardCloner);
                }
                player.m_5661_((Component)PASTE_MODE_MESSAGES[CardCloner.getPasteNetworkSettings(cardCloner) ? 0 : 1], true);
                player.m_216990_(SoundEvents.f_11871_);
                return InteractionResultHolder.m_19098_((Object)cardCloner);
            }
            if (player.m_6144_()) {
                CompoundTag cardClonerTag = cardCloner.m_41784_();
                cardClonerTag.m_128473_("itemType");
                cardClonerTag.m_128473_("settings");
                cardClonerTag.m_128473_("nodeData");
                return InteractionResultHolder.m_19098_((Object)cardCloner);
            }
            CardCloner.setPasteNetworkSettings(cardCloner, !CardCloner.getPasteNetworkSettings(cardCloner));
            return InteractionResultHolder.m_19098_((Object)cardCloner);
        }
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)cardCloner);
        }
        BlockPos targetPos = lookingAt.m_82425_();
        BlockEntity targetBE = level.m_7702_(targetPos);
        if (!(targetBE instanceof LaserNodeBE)) {
            return InteractionResultHolder.m_19098_((Object)cardCloner);
        }
        LaserNodeBE laserNodeBE = (LaserNodeBE)targetBE;
        if (player.m_6144_()) {
            CompoundTag nodeTag = new CompoundTag();
            laserNodeBE.m_183515_(nodeTag);
            String dimensionName = level.m_46472_().m_135782_().m_214299_();
            nodeTag.m_128359_("dimension", dimensionName);
            CardCloner.setNodeData(cardCloner, nodeTag);
            player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.node_copied"), true);
            SoundUtil.playSound(player, SoundEvents.f_12493_);
            return InteractionResultHolder.m_19090_((Object)cardCloner);
        }
        CompoundTag nodeTag = CardCloner.getNodeData(cardCloner);
        if (nodeTag.m_128456_()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.copy_node_first"), true);
            SoundUtil.playSound(player, SoundEvents.f_276627_);
            return InteractionResultHolder.m_19098_((Object)cardCloner);
        }
        if (CardCloner.getPasteNetworkSettings(cardCloner)) {
            Color laserColor = new Color(nodeTag.m_128451_("laserColor"), true);
            laserNodeBE.setColor(laserColor, nodeTag.m_128451_("wrenchAlpha"));
            laserNodeBE.discoverAllNodes();
            player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.network_settings_pasted"), true);
            SoundUtil.playSound(player, SoundEvents.f_11887_);
            return InteractionResultHolder.m_19090_((Object)cardCloner);
        }
        ItemStack cardHolder = LaserNode.findFirstCardHolder(player);
        ItemHandlerUtil.InventoryCardCounts neededItems = CardCloner.getCopiedNodeContents(cardCloner);
        ItemHandlerUtil.InventoryCardCounts existingItems = laserNodeBE.getNodeContents();
        existingItems.subtractInventoryCardCounts(neededItems);
        boolean enoughItems = true;
        if (existingItems.hasNegativeValues()) {
            if (!cardHolder.m_41619_()) {
                ItemHandlerUtil.InventoryCardCounts totalExistingItems = existingItems.clone();
                ItemHandlerUtil.InventoryCardCounts cardHolderItems = CardHolder.getContents(cardHolder);
                totalExistingItems.addInventoryCardCounts(cardHolderItems);
                enoughItems = !totalExistingItems.hasNegativeValues();
            } else {
                enoughItems = false;
            }
        }
        if (enoughItems) {
            CardCloner.transferItems(existingItems.getCardCounts(), existingItems, cardHolder, player);
            CardCloner.transferItems(existingItems.getCardModifierCounts(), existingItems, cardHolder, player);
            laserNodeBE.m_142466_(nodeTag.m_6426_());
            laserNodeBE.updateThisNode();
            player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.node_contents_pasted"), true);
            SoundUtil.playSound(player, SoundEvents.f_11887_);
            return InteractionResultHolder.m_19090_((Object)cardCloner);
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.laserio.card_cloner.insufficient_materials"), true);
        SoundUtil.playSound(player, SoundEvents.f_276627_);
        return InteractionResultHolder.m_19098_((Object)cardCloner);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (world == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        boolean ctrlPressed = Screen.m_96637_();
        if (!sneakPressed) {
            tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.show_details", ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_node_ui", ChatFormatting.GRAY));
            MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_node_ui.copy_card", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.left_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_node_ui.paste_card", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_world", ChatFormatting.GRAY));
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_world.copy_node", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.shift_right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_world.paste_node", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_world.clear", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.shift_right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.in_world.change_paste_mode", " - ", ChatFormatting.GRAY);
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.keys.right_click", ChatFormatting.WHITE));
            tooltip.add((Component)toWrite);
        }
        if (!ctrlPressed) {
            tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.show_settings.ctrl_key", ChatFormatting.GRAY));
        } else {
            CardCloner.appendHoverTextCopiedCard(stack, tooltip);
            CardCloner.appendHoverTextCopiedNode(stack, tooltip);
        }
    }

    private static void transferItems(Object2IntOpenHashMap<Item> itemCounts, ItemHandlerUtil.InventoryCardCounts inventoryCardCounts, ItemStack cardHolder, Player player) {
        itemCounts.object2IntEntrySet().fastForEach(entry -> {
            Item item = (Item)entry.getKey();
            int quantity = entry.getIntValue();
            while (quantity != 0) {
                if (quantity < 0) {
                    int quantityToRetrieve = Math.min(-quantity, 64);
                    ItemStack stackToRetrieve = new ItemStack((ItemLike)item, quantityToRetrieve);
                    ItemStack retrievedStack = CardHolder.getCardFromInventory(cardHolder, stackToRetrieve);
                    int retrievedQuantity = retrievedStack.m_41613_();
                    if (retrievedQuantity != 0) {
                        inventoryCardCounts.addCardModifiersFromCard(retrievedStack);
                        quantity += retrievedQuantity;
                        continue;
                    }
                    quantity = 0;
                    continue;
                }
                if (!cardHolder.m_41619_()) {
                    int quantityToDeposit = Math.min(quantity, 64);
                    ItemStack stackToDeposit = new ItemStack((ItemLike)item, quantityToDeposit);
                    ItemStack depositedStack = CardHolder.addCardToInventory(cardHolder, stackToDeposit);
                    int depositedQuantity = quantityToDeposit - depositedStack.m_41613_();
                    quantity -= depositedQuantity;
                    if (depositedQuantity == quantityToDeposit) continue;
                }
                int maxStackSize = item.m_41459_();
                while (quantity != 0) {
                    int quantityToDrop = Math.min(quantity, maxStackSize);
                    ItemStack stackToDrop = new ItemStack((ItemLike)item, quantityToDrop);
                    ItemEntity entityToDrop = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stackToDrop);
                    player.m_9236_().m_7967_((Entity)entityToDrop);
                    quantity -= quantityToDrop;
                }
            }
        });
    }

    private static void appendHoverTextCopiedCard(ItemStack stack, List<Component> tooltip) {
        ChatFormatting cardColor;
        tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.copied_card", ChatFormatting.GRAY));
        String cardType = CardCloner.getItemType(stack);
        boolean isEnergyCard = false;
        boolean isRedstoneCard = false;
        MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.filter.type", " - ", ChatFormatting.GRAY);
        switch (cardType) {
            case "card_item": {
                ChatFormatting chatFormatting = ChatFormatting.GREEN;
                break;
            }
            case "card_fluid": {
                ChatFormatting chatFormatting = ChatFormatting.BLUE;
                break;
            }
            case "card_energy": {
                isEnergyCard = true;
                ChatFormatting chatFormatting = ChatFormatting.YELLOW;
                break;
            }
            case "card_redstone": {
                isRedstoneCard = true;
                ChatFormatting chatFormatting = ChatFormatting.RED;
                break;
            }
            case "card_chemical": {
                ChatFormatting chatFormatting = ChatFormatting.LIGHT_PURPLE;
                break;
            }
            default: {
                ChatFormatting chatFormatting = cardColor = ChatFormatting.WHITE;
            }
        }
        if (cardType.equals("")) {
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", cardColor));
        } else {
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + cardType, cardColor));
        }
        tooltip.add((Component)toWrite);
        if (cardType.equals("")) {
            return;
        }
        CompoundTag compoundTag = stack.m_41784_().m_128469_("settings");
        byte mode = !compoundTag.m_128441_("mode") ? (byte)0 : compoundTag.m_128445_("mode");
        BaseCard.TransferMode currentMode = BaseCard.TransferMode.values()[mode];
        toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.mode", " - ", ChatFormatting.GRAY);
        ChatFormatting modeColor = switch (currentMode) {
            case BaseCard.TransferMode.EXTRACT -> ChatFormatting.RED;
            case BaseCard.TransferMode.INSERT -> ChatFormatting.GREEN;
            case BaseCard.TransferMode.STOCK -> ChatFormatting.BLUE;
            case BaseCard.TransferMode.SENSOR -> ChatFormatting.YELLOW;
            default -> ChatFormatting.GRAY;
        };
        toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.mode." + currentMode, modeColor));
        tooltip.add((Component)toWrite);
        toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.channel", " - ", ChatFormatting.GRAY);
        byte channel = !compoundTag.m_128441_("channel") ? (byte)0 : compoundTag.m_128445_("channel");
        toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(channel), LaserNodeBERender.COLORS[channel].getRGB()));
        tooltip.add((Component)toWrite);
        if (isRedstoneCard) {
            return;
        }
        if (!isEnergyCard) {
            toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Filter", " - ", ChatFormatting.GRAY);
            ItemStack filterStack = CardCloner.getCopiedCardFilter(stack);
            if (filterStack.m_41619_()) {
                toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", ChatFormatting.WHITE));
            } else {
                toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + filterStack.m_41720_(), ChatFormatting.DARK_AQUA));
            }
            tooltip.add((Component)toWrite);
        }
        if (!isEnergyCard || isEnergyCard && CardEnergyContainer.SLOTS == 1) {
            ItemStack overclockerStack = CardCloner.getCopiedCardOverclocker(stack);
            if (isEnergyCard) {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Overclocker", " - ", ChatFormatting.GRAY);
                if (overclockerStack.m_41619_()) {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", ChatFormatting.WHITE));
                } else {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker("item.laserio." + overclockerStack.m_41720_(), ChatFormatting.DARK_AQUA));
                }
            } else {
                toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card.Overclockers", " - ", ChatFormatting.GRAY);
                if (overclockerStack.m_41619_()) {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(0), ChatFormatting.WHITE));
                } else {
                    toWrite.m_7220_((Component)MiscTools.tooltipMaker(String.valueOf(overclockerStack.m_41613_()), ChatFormatting.DARK_AQUA));
                }
            }
            tooltip.add((Component)toWrite);
        }
    }

    private static void appendHoverTextCopiedNode(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.copied_node", ChatFormatting.GRAY));
        CompoundTag nodeTag = CardCloner.getNodeData(stack);
        MutableComponent toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.copied_node.position", " - ", ChatFormatting.GRAY);
        if (nodeTag.m_128456_()) {
            toWrite.m_7220_((Component)MiscTools.tooltipMaker("laserio.tooltip.item.card.None", ChatFormatting.WHITE));
        } else {
            toWrite.m_7220_((Component)MiscTools.tooltipMakerLiteral(nodeTag.m_128469_("myWorldPos").toString(), ChatFormatting.AQUA));
        }
        tooltip.add((Component)toWrite);
        if (nodeTag.m_128456_()) {
            return;
        }
        toWrite = MiscTools.tooltipMaker("laserio.tooltip.item.card_cloner.copied_node.dimension", " - ", ChatFormatting.GRAY);
        toWrite.m_7220_((Component)MiscTools.tooltipMakerLiteral(nodeTag.m_128461_("dimension"), ChatFormatting.DARK_AQUA));
        tooltip.add((Component)toWrite);
    }

    public static void setItemType(ItemStack stack, String itemType) {
        stack.m_41784_().m_128359_("itemType", itemType);
    }

    public static String getItemType(ItemStack stack) {
        return stack.m_41784_().m_128461_("itemType");
    }

    public static void setSettings(ItemStack stack, CompoundTag tag) {
        stack.m_41784_().m_128365_("settings", (Tag)tag);
    }

    public static CompoundTag getSettings(ItemStack stack) {
        return stack.m_41784_().m_128469_("settings");
    }

    public static ItemStack getCopiedCardFilter(ItemStack stack) {
        String cardType = CardCloner.getItemType(stack);
        CompoundTag cardTag = CardCloner.getSettings(stack);
        ItemStack filterStack = ItemStack.f_41583_;
        if (!cardType.equals("card_energy") && !cardType.equals("card_redstone")) {
            ItemStackHandler cardInvHandler = new ItemStackHandler(2);
            cardInvHandler.deserializeNBT(cardTag.m_128469_("inv"));
            filterStack = cardInvHandler.getStackInSlot(0);
        }
        return filterStack;
    }

    public static ItemStack getCopiedCardOverclocker(ItemStack stack) {
        String cardType = CardCloner.getItemType(stack);
        CompoundTag cardTag = CardCloner.getSettings(stack);
        ItemStack overclockStack = ItemStack.f_41583_;
        if (cardType.equals("card_energy")) {
            if (CardEnergyContainer.SLOTS == 1) {
                ItemStackHandler cardInvHandler = new ItemStackHandler(CardEnergyContainer.SLOTS);
                cardInvHandler.deserializeNBT(cardTag.m_128469_("inv"));
                overclockStack = cardInvHandler.getStackInSlot(0);
            }
        } else if (!cardType.equals("card_redstone")) {
            ItemStackHandler cardInvHandler = new ItemStackHandler(2);
            cardInvHandler.deserializeNBT(cardTag.m_128469_("inv"));
            overclockStack = cardInvHandler.getStackInSlot(1);
        }
        return overclockStack;
    }

    public static void setNodeData(ItemStack stack, CompoundTag tag) {
        stack.m_41784_().m_128365_("nodeData", (Tag)tag);
    }

    public static CompoundTag getNodeData(ItemStack stack) {
        return stack.m_41784_().m_128469_("nodeData");
    }

    public static ItemHandlerUtil.InventoryCardCounts getCopiedNodeContents(ItemStack stack) {
        ItemHandlerUtil.InventoryCardCounts nodeContents = new ItemHandlerUtil.InventoryCardCounts();
        CompoundTag nodeTag = CardCloner.getNodeData(stack);
        if (nodeTag.m_128456_()) {
            return nodeContents;
        }
        for (int i = 0; i < Direction.values().length; ++i) {
            ItemStackHandler nodeFaceInvHandler = new ItemStackHandler(10);
            nodeFaceInvHandler.deserializeNBT(nodeTag.m_128469_("Inventory" + i));
            nodeContents.addHandler((IItemHandler)nodeFaceInvHandler);
        }
        return nodeContents;
    }

    public static boolean setPasteNetworkSettings(ItemStack stack, boolean pasteNetworkSettings) {
        if (!pasteNetworkSettings) {
            stack.m_41749_("pasteNetworkSettings");
        } else {
            stack.m_41784_().m_128379_("pasteNetworkSettings", pasteNetworkSettings);
        }
        return pasteNetworkSettings;
    }

    public static boolean getPasteNetworkSettings(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_("pasteNetworkSettings")) {
            return false;
        }
        return compound.m_128471_("pasteNetworkSettings");
    }
}

