/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.containers;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.LaserNodeSlot;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.setup.Registration;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class LaserNodeContainer
extends AbstractContainerMenu {
    public static final int CARD_SLOTS = 9;
    public static final int SLOTS = 10;
    public Player playerEntity;
    private IItemHandler playerInventory;
    ContainerLevelAccess containerLevelAccess;
    public ItemStack cardHolder;
    public IItemHandler cardHolderHandler;
    public UUID cardHolderUUID;
    public LaserNodeBE tile;
    public byte side;

    public LaserNodeContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this((LaserNodeBE)playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), windowId, extraData.readByte(), playerInventory, player, new LaserNodeItemHandler(10), ContainerLevelAccess.f_39287_, extraData.m_130267_());
    }

    public LaserNodeContainer(@Nullable LaserNodeBE tile, int windowId, byte side, Inventory playerInventory, Player player, LaserNodeItemHandler handler, ContainerLevelAccess containerLevelAccess, ItemStack cardHolder) {
        super((MenuType)Registration.LASER_NODE_CONTAINER.get(), windowId);
        this.playerEntity = player;
        this.tile = tile;
        this.side = side;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.containerLevelAccess = containerLevelAccess;
        if (handler != null) {
            this.addSlotBox((IItemHandler)handler, 0, 62, 32, 3, 18, 3, 18);
            this.addSlotRange((IItemHandler)handler, 9, 152, 78, 1, 18);
        }
        this.cardHolder = cardHolder;
        if (!cardHolder.m_41619_()) {
            this.cardHolderHandler = (IItemHandler)cardHolder.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse((Object)new ItemStackHandler(15));
            this.addSlotBox(this.cardHolderHandler, 0, -92, 32, 5, 18, 3, 18);
            this.cardHolderUUID = CardHolder.getUUID(cardHolder);
        }
        this.layoutPlayerInventorySlots(8, 99);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slotId >= 0) {
            ItemStack carriedItem;
            Slot slot = (Slot)this.f_38839_.get(slotId);
            ItemStack stackInSlot = slot.m_7993_();
            if (slot instanceof CardHolderSlot ? stackInSlot.m_41741_() == 1 && stackInSlot.m_41613_() > 1 && !(carriedItem = this.m_142621_()).m_41619_() && !stackInSlot.m_41619_() && !ItemStack.m_150942_((ItemStack)carriedItem, (ItemStack)stackInSlot) : stackInSlot.m_41720_() instanceof CardHolder && CardHolder.getUUID(stackInSlot).equals(this.cardHolderUUID)) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_6875_(Player playerIn) {
        if (!(this.cardHolderUUID == null || this.cardHolder.m_41720_() instanceof CardHolder && CardHolder.getUUID(this.cardHolder).equals(this.cardHolderUUID))) {
            return false;
        }
        return LaserNodeContainer.m_38889_((ContainerLevelAccess)this.containerLevelAccess, (Player)this.playerEntity, (Block)((Block)Registration.LASER_NODE_BLOCK.get()));
    }

    protected boolean m_38903_(ItemStack itemStack, int fromSlot, int toSlot, boolean p_38907_) {
        boolean flag = false;
        int i = fromSlot;
        if (p_38907_) {
            i = toSlot - 1;
        }
        while (!itemStack.m_41619_() && !(!p_38907_ ? i >= toSlot : i < fromSlot)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)itemstack)) {
                int maxSize;
                int j = itemstack.m_41613_() + itemStack.m_41613_();
                if (j <= (maxSize = Math.min(slot.m_6641_(), slot.m_5866_(itemStack)))) {
                    itemStack.m_41764_(0);
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    flag = true;
                } else if (itemstack.m_41613_() < maxSize) {
                    itemStack.m_41774_(maxSize - itemstack.m_41613_());
                    itemstack.m_41764_(maxSize);
                    slot.m_6654_();
                    flag = true;
                }
            }
            if (p_38907_) {
                --i;
                continue;
            }
            ++i;
        }
        if (!itemStack.m_41619_()) {
            i = p_38907_ ? toSlot - 1 : fromSlot;
            while (!(!p_38907_ ? i >= toSlot : i < fromSlot)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(itemStack) && slot1.m_7993_().m_41613_() < slot1.m_5866_(itemStack)) {
                    if (itemStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(itemStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(itemStack.m_41620_(slot1.m_5866_(itemStack)));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return !(slot instanceof CardHolderSlot) && !(slot instanceof LaserNodeSlot);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack stack = slot.m_7993_();
        if (slot instanceof CardHolderSlot) {
            ItemStack stackToMove = stack.m_41741_() == 1 ? stack.m_41620_(1) : stack;
            if (this.m_38903_(stackToMove, 0, 10, false)) {
                return ItemStack.f_41583_;
            }
            if (this.m_38903_(stackToMove, 25, 61, true)) {
                return ItemStack.f_41583_;
            }
            stack.m_41769_(1);
            return ItemStack.f_41583_;
        }
        if (index < 9) {
            if (!this.cardHolder.m_41619_()) {
                if (this.m_38903_(stack, 10, 25, false)) {
                    if (!playerIn.m_9236_().m_5776_() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                    return ItemStack.f_41583_;
                }
                if (super.m_38903_(stack, 25, 61, true)) {
                    if (!playerIn.m_9236_().m_5776_() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                    return ItemStack.f_41583_;
                }
            } else if (super.m_38903_(stack, 10, 46, true)) {
                if (!playerIn.m_9236_().m_5776_() && this.tile != null) {
                    this.tile.updateThisNode();
                }
                return ItemStack.f_41583_;
            }
        } else {
            if (stack.m_41720_() instanceof OverclockerNode) {
                itemStack = stack.m_41777_();
                if (!this.cardHolder.m_41619_()) {
                    if (index < 25) {
                        if (this.m_38903_(stack, 10, 25, false)) {
                            return ItemStack.f_41583_;
                        }
                        if (!super.m_38903_(stack, 25, 61, true)) {
                            return ItemStack.f_41583_;
                        }
                        slot.m_40234_(stack, itemStack);
                    } else {
                        if (!super.m_38903_(stack, 0, 10, false)) {
                            return ItemStack.f_41583_;
                        }
                        if (!playerIn.m_9236_().m_5776_() && this.tile != null) {
                            this.tile.updateThisNode();
                        }
                    }
                } else if (index < 10) {
                    if (!super.m_38903_(stack, 10, 46, true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_40234_(stack, itemStack);
                } else {
                    if (!super.m_38903_(stack, 0, 10, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (!playerIn.m_9236_().m_5776_() && this.tile != null) {
                        this.tile.updateThisNode();
                    }
                }
                if (stack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (stack.m_41613_() == itemStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(playerIn, stack);
                return itemStack;
            }
            if (stack.m_41720_() instanceof BaseCard || stack.m_41720_() instanceof BaseFilter || stack.m_41720_() instanceof OverclockerCard) {
                if (!this.cardHolder.m_41619_()) {
                    if (super.m_38903_(stack, 0, 9, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (this.m_38903_(stack, 10, 25, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (super.m_38903_(stack, 0, 9, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof LaserNodeItemHandler && index < 9) {
                this.m_38897_((Slot)new LaserNodeSlot(handler, index, x, y));
            } else if (handler.getSlots() == 15) {
                this.m_38897_((Slot)new CardHolderSlot(handler, index, x, y));
            } else {
                this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }
}

