/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blocks;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;

public class LaserNode
extends BaseLaserBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final String SCREEN_LASERNODE = "screen.laserio.lasernode";

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof LaserWrench || heldItem.m_41720_() instanceof CardCloner) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            final BlockEntity be = level.m_7702_(pos);
            if (be instanceof LaserNodeBE) {
                if (heldItem.m_41720_() instanceof BaseCard) {
                    LazyOptional itemHandler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, result.m_82434_());
                    itemHandler.ifPresent(h -> {
                        ItemStack remainingStack = LaserNode.insertItemToNode(h, heldItem, false);
                        player.m_21008_(InteractionHand.MAIN_HAND, remainingStack);
                    });
                } else {
                    final Direction direction = player.m_6144_() ? result.m_82434_().m_122424_() : result.m_82434_();
                    be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).ifPresent(h -> {
                        ItemStack cardHolder = LaserNode.findFirstCardHolder(player);
                        if (!cardHolder.m_41619_()) {
                            CardHolder.getUUID(cardHolder);
                        }
                        MenuProvider containerProvider = new MenuProvider(){
                            final /* synthetic */ IItemHandler val$h;
                            final /* synthetic */ ItemStack val$cardHolder;
                            {
                                this.val$h = iItemHandler;
                                this.val$cardHolder = itemStack;
                            }

                            public Component m_5446_() {
                                return Component.m_237115_((String)LaserNode.SCREEN_LASERNODE);
                            }

                            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                                return new LaserNodeContainer((LaserNodeBE)be, windowId, (byte)direction.ordinal(), playerInventory, playerEntity, (LaserNodeItemHandler)this.val$h, ContainerLevelAccess.m_39289_((Level)be.m_58904_(), (BlockPos)be.m_58899_()), this.val$cardHolder);
                            }
                        };
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, buf -> {
                            buf.m_130064_(pos);
                            buf.writeByte((int)((byte)direction.ordinal()));
                            buf.writeItemStack(cardHolder, false);
                        });
                    });
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack insertItemToNode(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < 9; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack findFirstCardHolder(Player player) {
        ItemStack cardHolder = ItemStack.f_41583_;
        if (ModList.get().isLoaded("curios")) {
            cardHolder = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findFirstCurio(stack -> stack.m_41720_() instanceof CardHolder).map(result -> result.stack()).orElse(ItemStack.f_41583_)).orElse(ItemStack.f_41583_);
        }
        if (cardHolder.m_41619_()) {
            Inventory playerInventory = player.m_150109_();
            for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
                ItemStack possibleCardHolder = (ItemStack)playerInventory.f_35974_.get(i);
                if (!(possibleCardHolder.m_41720_() instanceof CardHolder)) continue;
                cardHolder = possibleCardHolder;
                break;
            }
        }
        return cardHolder;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof LaserNodeBE) {
                    LaserNodeBE tile = (LaserNodeBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof LaserNodeBE) {
                LaserNodeBE tile = (LaserNodeBE)t;
                tile.tickServer();
            }
        };
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            laserNodeBE.rendersChecked = false;
            laserNodeBE.clearCachedInventories();
            laserNodeBE.redstoneChecked = false;
        }
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity = pBlockAccess.m_7702_(pPos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            return laserNodeBE.getRedstoneSide(pSide.m_122424_());
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LaserNodeBE) {
            LaserNodeBE laserNodeBE = (LaserNodeBE)blockEntity;
            if (direction == null || !laserNodeBE.redstoneCardSides.containsKey((byte)direction.m_122424_().ordinal())) {
                return false;
            }
            return laserNodeBE.redstoneCardSides.get((byte)direction.m_122424_().ordinal());
        }
        return false;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        LaserNodeBE laserNodeBE;
        BlockEntity blockEntity = pBlockAccess.m_7702_(pPos);
        if (blockEntity instanceof LaserNodeBE && (laserNodeBE = (LaserNodeBE)blockEntity).getRedstoneSideStrong(pSide.m_122424_())) {
            return laserNodeBE.getRedstoneSide(pSide.m_122424_());
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LaserNodeBE(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return SHAPE;
    }

    public float m_7749_(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (newState.m_60734_() != this && (tileEntity = worldIn.m_7702_(pos)) != null) {
            for (Direction direction : Direction.values()) {
                LazyOptional cap = tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
                cap.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

