/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserNodeScreen;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketChangeColor;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.Vec2i;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class LaserNodeSettingsScreen
extends Screen {
    private static final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/laser_node_settings.png");
    private final LaserNodeContainer container;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private int laserRed;
    private int laserGreen;
    private int laserBlue;
    private int laserAlpha;
    private int wrenchAlpha;
    private ForgeSlider sliderRed;
    private ForgeSlider sliderGreen;
    private ForgeSlider sliderBlue;
    private ForgeSlider sliderAlpha;
    private ForgeSlider sliderWrenchAlpha;
    private Map<ForgeSlider, IntConsumer> sliderMap;

    public LaserNodeSettingsScreen(LaserNodeContainer container, Component name) {
        super(name);
        this.container = container;
        this.imageHeight = 181;
        Color color = container.tile.getColor();
        this.laserRed = color.getRed();
        this.laserGreen = color.getGreen();
        this.laserBlue = color.getBlue();
        this.laserAlpha = color.getAlpha();
        this.wrenchAlpha = container.tile.getWrenchAlpha();
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        if (this.container.side != -1) {
            ExtendedButton returnButton = new ExtendedButton(this.leftPos - 25, this.topPos + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openTab(this.container.side));
            leftWidgets.add(returnButton);
        }
        ExtendedButton applyButton = new ExtendedButton(this.leftPos + 25, this.topPos + 150, 50, 20, (Component)Component.m_237115_((String)"screen.laserio.apply"), button -> this.syncColors());
        leftWidgets.add(applyButton);
        ExtendedButton defaultButton = new ExtendedButton(this.leftPos + 100, this.topPos + 150, 50, 20, (Component)Component.m_237115_((String)"screen.laserio.default"), button -> {
            Color defaultColor = this.container.tile.getDefaultColor();
            this.laserRed = defaultColor.getRed();
            this.sliderRed.m_93611_((double)this.laserRed);
            this.laserGreen = defaultColor.getGreen();
            this.sliderGreen.m_93611_((double)this.laserGreen);
            this.laserBlue = defaultColor.getBlue();
            this.sliderBlue.m_93611_((double)this.laserBlue);
            this.laserAlpha = defaultColor.getAlpha();
            this.sliderAlpha.m_93611_((double)this.laserAlpha);
            this.wrenchAlpha = 0;
            this.sliderWrenchAlpha.m_93611_(0.0);
            this.syncColors();
        });
        leftWidgets.add(defaultButton);
        this.sliderRed = new ForgeSlider(this.leftPos + 15, this.topPos + 45, 150, 15, (Component)Component.m_237115_((String)"screen.laserio.red").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.laserRed, true){

            protected void m_5697_() {
                LaserNodeSettingsScreen.this.laserRed = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderRed);
        this.sliderGreen = new ForgeSlider(this.leftPos + 15, this.topPos + 65, 150, 15, (Component)Component.m_237115_((String)"screen.laserio.green").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.laserGreen, true){

            protected void m_5697_() {
                LaserNodeSettingsScreen.this.laserGreen = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderGreen);
        this.sliderBlue = new ForgeSlider(this.leftPos + 15, this.topPos + 85, 150, 15, (Component)Component.m_237115_((String)"screen.laserio.blue").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.laserBlue, true){

            protected void m_5697_() {
                LaserNodeSettingsScreen.this.laserBlue = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderBlue);
        this.sliderAlpha = new ForgeSlider(this.leftPos + 15, this.topPos + 105, 150, 15, (Component)Component.m_237115_((String)"screen.laserio.alpha").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.laserAlpha, true){

            protected void m_5697_() {
                LaserNodeSettingsScreen.this.laserAlpha = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderAlpha);
        this.sliderWrenchAlpha = new ForgeSlider(this.leftPos + 15, this.topPos + 125, 150, 15, (Component)Component.m_237115_((String)"screen.laserio.wrench").m_130946_(": "), (Component)Component.m_237119_(), 0.0, 255.0, this.wrenchAlpha, true){

            protected void m_5697_() {
                LaserNodeSettingsScreen.this.wrenchAlpha = this.getValueInt();
            }
        };
        leftWidgets.add(this.sliderWrenchAlpha);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
        this.sliderMap = Map.of(this.sliderRed, a -> {
            this.laserRed = a;
        }, this.sliderGreen, a -> {
            this.laserGreen = a;
        }, this.sliderBlue, a -> {
            this.laserBlue = a;
        }, this.sliderAlpha, a -> {
            this.laserAlpha = a;
        }, this.sliderWrenchAlpha, a -> {
            this.wrenchAlpha = a;
        });
    }

    private void syncColors() {
        PacketHandler.sendToServer(new PacketChangeColor(this.container.tile.m_58899_(), new Color(this.laserRed, this.laserGreen, this.laserBlue, this.laserAlpha).getRGB(), this.wrenchAlpha));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.leftPos, (float)this.topPos, 0.0f);
        String settings = Component.m_237115_((String)"screen.laserio.network_settings").getString();
        int color = Color.DARK_GRAY.getRGB();
        guiGraphics.m_280056_(this.f_96547_, settings, this.imageWidth / 2 - this.f_96547_.m_92895_(settings) / 2, 20, color, false);
        guiGraphics.m_280056_(this.f_96547_, "U", 15, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "D", 43, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "N", 71, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "S", 99, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "W", 127, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "E", 155, 7, color, false);
        for (Direction direction : Direction.values()) {
            ItemStack itemStack = this.getAdjacentBlock(direction);
            if (itemStack.m_41619_()) continue;
            Vec2i tab = LaserNodeScreen.TABS[direction.ordinal()];
            guiGraphics.m_280256_(itemStack, tab.x + 4, tab.y - 14, 0);
            if (!MiscTools.inBounds(this.leftPos + tab.x + 4, this.topPos + tab.y - 14, 16, 16, mouseX, mouseY)) continue;
            guiGraphics.m_280153_(this.f_96547_, itemStack, mouseX - this.leftPos, mouseY - this.topPos);
        }
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int startX = 15;
        int startY = 30;
        guiGraphics.m_280509_(startX, startY, startX + 150, startY + 10, new Color(this.laserRed, this.laserGreen, this.laserBlue, this.laserAlpha).getRGB());
        guiGraphics.m_280168_().m_85849_();
    }

    protected ItemStack getAdjacentBlock(Direction direction) {
        BlockState blockState = this.container.playerEntity.m_9236_().m_8055_(this.container.tile.m_58899_().m_121945_(direction));
        ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
        return itemStack;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        guiGraphics.m_280218_(GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int tabOffset = LaserNodeScreen.TABS[this.container.side].x - 2;
        guiGraphics.m_280218_(LaserNodeScreen.SELECTED_TABS_OVERLAY, this.leftPos + tabOffset, this.topPos, tabOffset, 0, 28, 24);
    }

    private void openTab(byte tabIndex) {
        PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), tabIndex));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.sliderMap.forEach((slider, consumer) -> {
            if (slider.m_5953_(mouseX, mouseY)) {
                slider.m_93611_((double)(slider.getValueInt() + (delta > 0.0 ? 1 : -1)));
                consumer.accept(slider.getValueInt());
            }
        });
        return false;
    }

    public boolean m_6375_(double x, double y, int btn) {
        for (byte i = 0; i < LaserNodeScreen.TABS.length; i = (byte)(i + 1)) {
            Vec2i tab = LaserNodeScreen.TABS[i];
            if (!MiscTools.inBounds(this.leftPos + tab.x, this.topPos + tab.y, 24, 12, x, y)) continue;
            this.openTab(i);
            return true;
        }
        return super.m_6375_(x, y, btn);
    }

    public boolean m_7043_() {
        return false;
    }

    public int getGuiLeft() {
        return this.leftPos;
    }

    public int getGuiTop() {
        return this.topPos;
    }
}

