/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserNodeSettingsScreen;
import com.direwolf20.laserio.client.screens.widgets.IconButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.LaserNodeSlot;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketCopyPasteCard;
import com.direwolf20.laserio.common.network.packets.PacketOpenCard;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketToggleParticles;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.Vec2i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class LaserNodeScreen
extends AbstractContainerScreen<LaserNodeContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/laser_node.png");
    protected static final ResourceLocation SELECTED_TABS_OVERLAY = new ResourceLocation("laserio", "textures/gui/laser_node_selected_tabs.png");
    private static final ResourceLocation CARD_HOLDER_GUI = new ResourceLocation("laserio", "textures/gui/cardholder_node.png");
    private static final MutableComponent[] SIDES = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.down"), Component.m_237115_((String)"screen.laserio.up"), Component.m_237115_((String)"screen.laserio.north"), Component.m_237115_((String)"screen.laserio.south"), Component.m_237115_((String)"screen.laserio.west"), Component.m_237115_((String)"screen.laserio.east")};
    protected static final Vec2i[] TABS = new Vec2i[]{new Vec2i(34, 4), new Vec2i(6, 4), new Vec2i(62, 4), new Vec2i(90, 4), new Vec2i(118, 4), new Vec2i(146, 4)};
    private final LaserNodeContainer container;
    private boolean showCardHolderUI;
    private boolean currentParticles;
    private Button settingsButton;
    private Button particlesButton;

    public LaserNodeScreen(LaserNodeContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.f_97727_ = 181;
        this.showCardHolderUI = !container.cardHolder.m_41619_();
        this.currentParticles = container.tile.getShowParticles();
    }

    public boolean isCardHolderUIShown() {
        return this.showCardHolderUI;
    }

    public void m_7856_() {
        super.m_7856_();
        ArrayList<Button> leftWidgets = new ArrayList<Button>();
        ResourceLocation settings = new ResourceLocation("laserio", "textures/gui/buttons/settings.png");
        this.settingsButton = new IconButton(this.f_97735_ + 155, this.f_97736_ + 25, 16, 16, settings, button -> Minecraft.m_91087_().m_91152_((Screen)new LaserNodeSettingsScreen(this.container, (Component)Component.m_237115_((String)"screen.laserio.network_settings"))));
        leftWidgets.add(this.settingsButton);
        ResourceLocation[] regulateTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/regulatefalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/regulatetrue.png")};
        this.particlesButton = new ToggleButton(this.f_97735_ + 155, this.f_97736_ + 45, 16, 16, regulateTextures, this.currentParticles ? 1 : 0, button -> {
            this.currentParticles = !this.currentParticles;
            ((ToggleButton)button).setTexturePosition(this.currentParticles ? 1 : 0);
            PacketHandler.sendToServer(new PacketToggleParticles(this.currentParticles));
        });
        leftWidgets.add(this.particlesButton);
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showCardHolderUI) {
            return mouseX < (double)guiLeftIn - 100.0 || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.f_97726_) || mouseY >= (double)(guiTopIn + this.f_97727_);
        }
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.toggleHolderSlots();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.settingsButton.m_252754_(), this.settingsButton.m_252907_(), this.settingsButton.m_5711_(), this.settingsButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.network_settings"), mouseX, mouseY);
        }
        if (MiscTools.inBounds(this.particlesButton.m_252754_(), this.particlesButton.m_252907_(), this.particlesButton.m_5711_(), this.particlesButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.showparticles"), Component.m_237115_((String)"screen.laserio.hideparticles")};
            guiGraphics.m_280557_(this.f_96547_, (Component)(this.currentParticles ? translatableComponents[0] : translatableComponents[1]), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String side = SIDES[this.container.side].getString();
        int color = Color.DARK_GRAY.getRGB();
        guiGraphics.m_280056_(this.f_96547_, side, this.f_97726_ / 2 - this.f_96547_.m_92895_(side) / 2, 20, color, false);
        guiGraphics.m_280056_(this.f_96547_, "U", 15, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "D", 43, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "N", 71, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "S", 99, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "W", 127, 7, color, false);
        guiGraphics.m_280056_(this.f_96547_, "E", 155, 7, color, false);
        for (Direction direction : Direction.values()) {
            ItemStack itemStack = this.getAdjacentBlock(direction);
            if (itemStack.m_41619_()) continue;
            Vec2i tab = TABS[direction.ordinal()];
            guiGraphics.m_280256_(itemStack, tab.x + 4, tab.y - 14, 0);
            if (!MiscTools.inBounds(this.f_97735_ + tab.x + 4, this.f_97736_ + tab.y - 14, 16, 16, mouseX, mouseY)) continue;
            guiGraphics.m_280153_(this.f_96547_, itemStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected ItemStack getAdjacentBlock(Direction direction) {
        BlockState blockState = this.container.playerEntity.m_9236_().m_8055_(this.container.tile.m_58899_().m_121945_(direction));
        ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
        return itemStack;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        guiGraphics.m_280218_(GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int tabOffset = LaserNodeScreen.TABS[this.container.side].x - 2;
        guiGraphics.m_280218_(SELECTED_TABS_OVERLAY, this.f_97735_ + tabOffset, this.f_97736_, tabOffset, 0, 28, 24);
        if (this.showCardHolderUI) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CARD_HOLDER_GUI);
            guiGraphics.m_280218_(CARD_HOLDER_GUI, this.f_97735_ - 100, this.f_97736_ + 24, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    public void toggleHolderSlots() {
        for (int i = 9; i < 24; ++i) {
            Slot slot;
            if (i >= this.container.f_38839_.size() || !((slot = this.container.m_38853_(i)) instanceof CardHolderSlot)) continue;
            CardHolderSlot cardHolderSlot = (CardHolderSlot)slot;
            cardHolderSlot.setEnabled(this.showCardHolderUI);
        }
    }

    private void openTab(byte tabIndex) {
        PacketHandler.sendToServer(new PacketOpenNode(this.container.tile.m_58899_(), tabIndex));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        byte tabIndex;
        if (delta > 0.0) {
            tabIndex = switch (this.container.side) {
                case 1 -> 0;
                case 0 -> 2;
                default -> (byte)(this.container.side + 1);
            };
        } else {
            switch (this.container.side) {
                default: {
                    byte by = (byte)(this.container.side - 1);
                    break;
                }
                case 2: {
                    byte by = 0;
                    break;
                }
                case 0: {
                    byte by = 1;
                    break;
                }
                case 1: {
                    byte by = tabIndex = -1;
                }
            }
        }
        if (tabIndex >= 0 && tabIndex < TABS.length) {
            this.openTab(tabIndex);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double x, double y, int btn) {
        if (this.f_97734_ != null && this.container.m_142621_().m_41720_() instanceof CardCloner) {
            if (this.f_97734_ instanceof LaserNodeSlot) {
                if (btn == 0) {
                    PacketHandler.sendToServer(new PacketCopyPasteCard(this.f_97734_.getSlotIndex(), true));
                } else if (btn == 1) {
                    PacketHandler.sendToServer(new PacketCopyPasteCard(this.f_97734_.getSlotIndex(), false));
                }
            }
            return true;
        }
        for (byte i = 0; i < TABS.length; i = (byte)((byte)(i + 1))) {
            Vec2i tab = TABS[i];
            if (!MiscTools.inBounds(this.f_97735_ + tab.x, this.f_97736_ + tab.y, 24, 12, x, y) || this.container.side == i) continue;
            this.openTab(i);
            return true;
        }
        if (this.f_97734_ == null || this.f_97734_.m_7993_().m_41619_() || !(this.f_97734_.m_7993_().m_41720_() instanceof BaseCard)) {
            return super.m_6375_(x, y, btn);
        }
        if (btn == 1 && this.f_97734_ instanceof LaserNodeSlot) {
            int slot = this.f_97734_.getSlotIndex();
            PacketHandler.sendToServer(new PacketOpenCard(slot, this.container.tile.m_58899_(), LaserNodeScreen.m_96638_()));
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

