/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.CardChemicalScreen;
import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LaserGuiGraphicsChemical
extends GuiGraphics {
    private final CardItemScreen screen;

    public LaserGuiGraphicsChemical(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource, CardItemScreen screen) {
        super(minecraft, bufferSource);
        this.screen = screen;
    }

    private void fillRect(BufferBuilder p_115153_, int p_115154_, int p_115155_, int p_115156_, int p_115157_, int p_115158_, int p_115159_, int p_115160_, int p_115161_) {
        Matrix4f matrix4f = this.m_280168_().m_85850_().m_252922_();
        VertexConsumer vertexconsumer = this.m_280091_().m_6299_(RenderType.m_286086_());
        vertexconsumer.m_252986_(matrix4f, (float)(p_115154_ + 0), (float)(p_115155_ + 0), 0.0f).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)(p_115154_ + 0), (float)(p_115155_ + p_115157_), 0.0f).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)(p_115154_ + p_115156_), (float)(p_115155_ + p_115157_), 0.0f).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)(p_115154_ + p_115156_), (float)(p_115155_ + 0), 0.0f).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        this.m_280262_();
    }

    public void m_280302_(Font font, ItemStack itemstack, int x, int y, @Nullable String altText) {
        if (this.shouldRenderChemical(itemstack, x, y, true, false)) {
            CardChemicalScreen cardChemicalScreen = (CardChemicalScreen)this.screen;
            int sloty = (int)Math.floor((y - cardChemicalScreen.filterStartY) / 18);
            int slotx = (int)Math.floor((x - cardChemicalScreen.filterStartX) / 18);
            int slot = 5 * sloty + slotx;
            ItemStack filter = ((CardChemicalScreen)this.screen).filter;
            int totalmbAmt = FilterCount.getSlotAmount(filter, slot);
            int count = (int)Math.floor(totalmbAmt / 1000);
            int mbAmt = totalmbAmt % 1000;
            PoseStack posestack = this.m_280168_();
            if (count != 0 || mbAmt != 0) {
                String textToDraw = count + "b";
                posestack.m_85836_();
                posestack.m_252880_((float)x, (float)y, 200.0f);
                posestack.m_85841_(0.5f, 0.5f, 0.5f);
                if (mbAmt == 0) {
                    this.drawString(font, textToDraw, 17.0f - (float)font.m_92895_(textToDraw) * 0.5f, 24.0f, 0xFFFFFF, true);
                } else {
                    String textToDraw2 = mbAmt + "mb";
                    this.drawString(font, textToDraw, 17.0f - (float)font.m_92895_(textToDraw) * 0.5f, 14.0f, 0xFFFFFF, true);
                    this.drawString(font, textToDraw2, 17.0f - (float)font.m_92895_(textToDraw2) * 0.5f, 24.0f, 0xFFFFFF, true);
                }
                posestack.m_85849_();
            }
        } else if (!itemstack.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = this.m_280168_();
            if (itemstack.m_41613_() != 1 || altText != null) {
                String textToDraw = altText == null ? String.valueOf(itemstack.m_41613_()) : altText;
                posestack.m_85837_(0.0, 0.0, 200.0);
                if (itemstack.m_41613_() > 99) {
                    posestack.m_85836_();
                    posestack.m_252880_((float)x, (float)y, 300.0f);
                    posestack.m_85841_(0.65f, 0.65f, 0.65f);
                    this.drawString(font, textToDraw, 17.0f - (float)font.m_92895_(textToDraw) * 0.65f, 17.0f, 0xFFFFFF, true);
                    posestack.m_85849_();
                } else {
                    this.drawString(font, textToDraw, x + 19 - 2 - font.m_92895_(textToDraw), y + 6 + 3, 0xFFFFFF, true);
                }
            }
            if (!this.shouldRenderChemical(itemstack, x, y, true, true)) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                this.fillRect(bufferbuilder1, x, y, 16, Mth.m_14167_((float)16.0f), 255, 0, 0, 127);
            }
            if (itemstack.m_150947_()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                int i = itemstack.m_150948_();
                int j = itemstack.m_150949_();
                this.fillRect(bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                this.fillRect(bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            }
            float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(itemstack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                this.fillRect(bufferbuilder1, x, y + Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    public boolean shouldRenderChemical(ItemStack pStack, int pX, int pY, boolean includeCarried, boolean reverseBounds) {
        if (!(this.screen instanceof CardChemicalScreen)) {
            return reverseBounds;
        }
        CardChemicalScreen cardChemicalScreen = (CardChemicalScreen)this.screen;
        if (((CardItemContainer)cardChemicalScreen.m_6262_()).m_142621_().equals(pStack) && includeCarried) {
            return reverseBounds;
        }
        if (reverseBounds) {
            return !MiscTools.inBounds(cardChemicalScreen.filterStartX, cardChemicalScreen.filterStartY, cardChemicalScreen.filterEndX - cardChemicalScreen.filterStartX, cardChemicalScreen.filterEndY - cardChemicalScreen.filterStartY, pX, pY);
        }
        if (!MiscTools.inBounds(cardChemicalScreen.filterStartX, cardChemicalScreen.filterStartY, cardChemicalScreen.filterEndX - cardChemicalScreen.filterStartX, cardChemicalScreen.filterEndY - cardChemicalScreen.filterStartY, pX, pY)) {
            return reverseBounds;
        }
        ChemicalStack<?> chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(pStack);
        if (chemicalStack.isEmpty()) {
            return reverseBounds;
        }
        ResourceLocation chemicalStill = chemicalStack.getType().getIcon();
        TextureAtlasSprite chemicalStillSprite = null;
        if (chemicalStill != null) {
            chemicalStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(chemicalStill);
        }
        return chemicalStillSprite != null ^ reverseBounds;
    }

    public void m_280256_(ItemStack pStack, int pX, int pY, int something) {
        if (!this.shouldRenderChemical(pStack, pX, pY, true, false)) {
            super.m_280256_(pStack, pX, pY, something);
            return;
        }
        ChemicalStack<?> chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(pStack);
        ResourceLocation chemicalStill = chemicalStack.getType().getIcon();
        TextureAtlasSprite chamicalStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(chemicalStill);
        int chemicalColor = chemicalStack.getChemicalColorRepresentation();
        float red = (float)(chemicalColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(chemicalColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(chemicalColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        PoseStack posestack = this.m_280168_();
        posestack.m_85836_();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        int zLevel = 100;
        float uMin = chamicalStillSprite.m_118409_();
        float uMax = chamicalStillSprite.m_118410_();
        float vMin = chamicalStillSprite.m_118411_();
        float vMax = chamicalStillSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_252986_(posestack.m_85850_().m_252922_(), (float)pX, (float)pY + 16.0f, (float)zLevel).m_7421_(uMin, vMax).m_5752_();
        vertexBuffer.m_252986_(posestack.m_85850_().m_252922_(), (float)pX + 16.0f, (float)pY + 16.0f, (float)zLevel).m_7421_(uMax, vMax).m_5752_();
        vertexBuffer.m_252986_(posestack.m_85850_().m_252922_(), (float)pX + 16.0f, (float)pY, (float)zLevel).m_7421_(uMax, vMin).m_5752_();
        vertexBuffer.m_252986_(posestack.m_85850_().m_252922_(), (float)pX, (float)pY, (float)zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
        posestack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }
}

