/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateRedstoneCard;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CardRedstoneScreen
extends AbstractContainerScreen<CardRedstoneContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/redstonecard.png");
    private final CardRedstoneContainer container;
    private byte currentMode;
    private byte currentRedstoneChannel;
    private boolean currentInterval;
    private byte currentIntervalLowerBound;
    private byte currentIntervalUpperBound;
    private byte currentIntervalOutput;
    private boolean currentStrong;
    private byte currentOutputMode;
    private byte currentLogicOperation;
    private byte currentLogicOperationChannel;
    private final ItemStack card;
    private final Map<String, Button> buttons = new HashMap<String, Button>();

    public CardRedstoneScreen(CardRedstoneContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.m_252754_(), modeButton.m_252907_(), modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.input"), Component.m_237115_((String)"screen.laserio.output")};
            guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (this.currentMode == 0) {
            Button intervalToggleButton = this.buttons.get("intervalToggle");
            if (MiscTools.inBounds(intervalToggleButton.m_252754_(), intervalToggleButton.m_252907_(), intervalToggleButton.m_5711_(), intervalToggleButton.m_93694_(), mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.interval"), mouseX, mouseY);
            }
            if (this.currentInterval) {
                Button intervalOutputButton;
                Button intervalUpperBoundButton;
                Button intervalLowerBoundButton = this.buttons.get("intervalLowerBound");
                if (MiscTools.inBounds(intervalLowerBoundButton.m_252754_(), intervalLowerBoundButton.m_252907_(), intervalLowerBoundButton.m_5711_(), intervalLowerBoundButton.m_93694_(), mouseX, mouseY)) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.interval.lower_bound"), mouseX, mouseY);
                }
                if (MiscTools.inBounds((intervalUpperBoundButton = this.buttons.get("intervalUpperBound")).m_252754_(), intervalUpperBoundButton.m_252907_(), intervalUpperBoundButton.m_5711_(), intervalUpperBoundButton.m_93694_(), mouseX, mouseY)) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.interval.upper_bound"), mouseX, mouseY);
                }
                if (MiscTools.inBounds((intervalOutputButton = this.buttons.get("intervalOutput")).m_252754_(), intervalOutputButton.m_252907_(), intervalOutputButton.m_5711_(), intervalOutputButton.m_93694_(), mouseX, mouseY)) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstone.interval.output"), mouseX, mouseY);
                }
            }
        } else {
            Button logicOperationChannelButton;
            Button logicOperationButton;
            Button outputModeButton;
            Button strongButton = this.buttons.get("strong");
            if (MiscTools.inBounds(strongButton.m_252754_(), strongButton.m_252907_(), strongButton.m_5711_(), strongButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.weak"), Component.m_237115_((String)"screen.laserio.strong")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentStrong ? 1 : 0], mouseX, mouseY);
            }
            if (MiscTools.inBounds((outputModeButton = this.buttons.get("outputMode")).m_252754_(), outputModeButton.m_252907_(), outputModeButton.m_5711_(), outputModeButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.redstone.output_mode.normal"), Component.m_237115_((String)"screen.laserio.redstone.output_mode.complementary"), Component.m_237115_((String)"screen.laserio.redstone.output_mode.not")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentOutputMode], mouseX, mouseY);
            }
            if (MiscTools.inBounds((logicOperationButton = this.buttons.get("logicOperation")).m_252754_(), logicOperationButton.m_252907_(), logicOperationButton.m_5711_(), logicOperationButton.m_93694_(), mouseX, mouseY)) {
                MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.redstone.logic_operation.none"), Component.m_237115_((String)"screen.laserio.redstone.logic_operation.or"), Component.m_237115_((String)"screen.laserio.redstone.logic_operation.and"), Component.m_237115_((String)"screen.laserio.redstone.logic_operation.xor")};
                guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentLogicOperation], mouseX, mouseY);
            }
            if (this.currentLogicOperation != 0 && MiscTools.inBounds((logicOperationChannelButton = this.buttons.get("logicOperationChannel")).m_252754_(), logicOperationChannelButton.m_252907_(), logicOperationChannelButton.m_5711_(), logicOperationChannelButton.m_93694_(), mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentLogicOperationChannel)), mouseX, mouseY);
            }
        }
        Button channelButton = this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneinput.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneoutput.png")};
        this.buttons.put("mode", new ToggleButton(this.f_97735_ + 5, this.f_97736_ + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = CardRedstone.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            this.modeChange();
        }));
    }

    public void addChannelButton() {
        this.buttons.put("channel", new ChannelButton(this.f_97735_ + 5, this.f_97736_ + 65, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void addIntervalToggleButton() {
        ResourceLocation[] intervalTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneintervalfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneintervaltrue.png")};
        this.buttons.put("intervalToggle", new ToggleButton(this.f_97735_ + 5, this.f_97736_ + 25, 16, 16, intervalTextures, this.currentInterval ? 1 : 0, button -> {
            this.currentInterval = !this.currentInterval;
            ((ToggleButton)button).setTexturePosition(this.currentInterval ? 1 : 0);
            this.intervalChange();
        }));
    }

    public void addIntervalLowerBoundButton() {
        this.buttons.put("intervalLowerBound", new NumberButton(this.f_97735_ + 25, this.f_97736_ + 25, 16, 16, this.currentIntervalLowerBound, button -> this.changeIntervalLowerBound(-1)));
    }

    public void addIntervalUpperBoundButton() {
        this.buttons.put("intervalUpperBound", new NumberButton(this.f_97735_ + 45, this.f_97736_ + 25, 16, 16, this.currentIntervalUpperBound, button -> this.changeIntervalUpperBound(-1)));
    }

    public void addIntervalOutputButton() {
        this.buttons.put("intervalOutput", new NumberButton(this.f_97735_ + 65, this.f_97736_ + 25, 16, 16, this.currentIntervalOutput, button -> this.changeIntervalOutput(-1)));
    }

    public void addStrongButton() {
        ResourceLocation[] strongTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("strong", new ToggleButton(this.f_97735_ + 5, this.f_97736_ + 25, 16, 16, strongTextures, this.currentStrong ? 1 : 0, button -> {
            this.currentStrong = !this.currentStrong;
            ((ToggleButton)button).setTexturePosition(this.currentStrong ? 1 : 0);
        }));
    }

    public void addOutputModeButton() {
        ResourceLocation[] outputModeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonenormal.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonecomplementary.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonenot.png")};
        this.buttons.put("outputMode", new ToggleButton(this.f_97735_ + 155, this.f_97736_ + 5, 16, 16, outputModeTextures, this.currentOutputMode, button -> {
            this.currentOutputMode = (byte)(this.currentOutputMode == 2 ? 0 : this.currentOutputMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentOutputMode);
        }));
    }

    public void addLogicOperationButton() {
        ResourceLocation[] logicOperationTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonenologicoperation.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneor.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneand.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonexor.png")};
        this.buttons.put("logicOperation", new ToggleButton(this.f_97735_ + 155, this.f_97736_ + 25, 16, 16, logicOperationTextures, this.currentLogicOperation, button -> {
            this.currentLogicOperation = (byte)(this.currentLogicOperation == 3 ? 0 : this.currentLogicOperation + 1);
            ((ToggleButton)button).setTexturePosition(this.currentLogicOperation);
            this.logicOperationChange();
        }));
    }

    public void addLogicOperationChannelButton() {
        this.buttons.put("logicOperationChannel", new ChannelButton(this.f_97735_ + 135, this.f_97736_ + 25, 16, 16, this.currentLogicOperationChannel, button -> {
            this.currentLogicOperationChannel = CardRedstone.nextRedstoneChannelOperation(this.card);
            ((ChannelButton)button).setChannel(this.currentLogicOperationChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        this.currentMode = CardRedstone.getTransferMode(this.card);
        this.currentRedstoneChannel = CardRedstone.getRedstoneChannel(this.card);
        this.currentInterval = CardRedstone.getInterval(this.card);
        this.currentIntervalLowerBound = CardRedstone.getIntervalLowerBound(this.card);
        this.currentIntervalUpperBound = CardRedstone.getIntervalUpperBound(this.card);
        this.currentIntervalOutput = CardRedstone.getIntervalOutput(this.card);
        this.currentStrong = CardRedstone.getStrong(this.card);
        this.currentOutputMode = CardRedstone.getOutputMode(this.card);
        this.currentLogicOperation = CardRedstone.getLogicOperation(this.card);
        this.currentLogicOperationChannel = CardRedstone.getRedstoneChannelOperation(this.card);
        this.addModeButton();
        this.addChannelButton();
        this.addIntervalToggleButton();
        this.addIntervalLowerBoundButton();
        this.addIntervalUpperBoundButton();
        this.addIntervalOutputButton();
        this.addStrongButton();
        this.addOutputModeButton();
        this.addLogicOperationButton();
        this.addLogicOperationChannelButton();
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.f_97735_ - 25, this.f_97736_ + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button strongButton = this.buttons.get("strong");
        Button outputModeButton = this.buttons.get("outputMode");
        Button intervalToggleButton = this.buttons.get("intervalToggle");
        Button intervalLowerBoundButton = this.buttons.get("intervalLowerBound");
        Button intervalUpperBoundButton = this.buttons.get("intervalUpperBound");
        Button intervalOutputButton = this.buttons.get("intervalOutput");
        Button logicOperationButton = this.buttons.get("logicOperation");
        Button logicOperationChannelButton = this.buttons.get("logicOperationChannel");
        if (this.currentMode == 0) {
            if (!this.f_169369_.contains(intervalToggleButton)) {
                this.m_142416_((GuiEventListener)intervalToggleButton);
            }
            this.m_169411_((GuiEventListener)strongButton);
            this.m_169411_((GuiEventListener)outputModeButton);
            this.m_169411_((GuiEventListener)logicOperationButton);
            this.m_169411_((GuiEventListener)logicOperationChannelButton);
            this.intervalChange();
        } else {
            if (!this.f_169369_.contains(strongButton)) {
                this.m_142416_((GuiEventListener)strongButton);
            }
            if (!this.f_169369_.contains(outputModeButton)) {
                this.m_142416_((GuiEventListener)outputModeButton);
            }
            if (!this.f_169369_.contains(logicOperationButton)) {
                this.m_142416_((GuiEventListener)logicOperationButton);
            }
            if (!this.f_169369_.contains(logicOperationChannelButton)) {
                this.m_142416_((GuiEventListener)logicOperationChannelButton);
            }
            this.m_169411_((GuiEventListener)intervalToggleButton);
            this.m_169411_((GuiEventListener)intervalLowerBoundButton);
            this.m_169411_((GuiEventListener)intervalUpperBoundButton);
            this.m_169411_((GuiEventListener)intervalOutputButton);
            this.logicOperationChange();
        }
    }

    public void intervalChange() {
        Button intervalLowerBoundButton = this.buttons.get("intervalLowerBound");
        Button intervalUpperBoundButton = this.buttons.get("intervalUpperBound");
        Button intervalOutputButton = this.buttons.get("intervalOutput");
        if (this.currentInterval) {
            if (!this.f_169369_.contains(intervalLowerBoundButton)) {
                this.m_142416_((GuiEventListener)intervalLowerBoundButton);
            }
            if (!this.f_169369_.contains(intervalUpperBoundButton)) {
                this.m_142416_((GuiEventListener)intervalUpperBoundButton);
            }
            if (!this.f_169369_.contains(intervalOutputButton)) {
                this.m_142416_((GuiEventListener)intervalOutputButton);
            }
        } else {
            this.m_169411_((GuiEventListener)intervalLowerBoundButton);
            this.m_169411_((GuiEventListener)intervalUpperBoundButton);
            this.m_169411_((GuiEventListener)intervalOutputButton);
        }
    }

    public void logicOperationChange() {
        Button logicOperationChannelButton = this.buttons.get("logicOperationChannel");
        if (this.currentLogicOperation != 0) {
            if (!this.f_169369_.contains(logicOperationChannelButton)) {
                this.m_142416_((GuiEventListener)logicOperationChannelButton);
            }
        } else {
            this.m_169411_((GuiEventListener)logicOperationChannelButton);
        }
    }

    public void changeIntervalLowerBound(int change) {
        if (Screen.m_96638_()) {
            change *= 15;
        }
        this.currentIntervalLowerBound = change < 0 ? (byte)Math.max(this.currentIntervalLowerBound + change, 0) : (byte)Math.min(this.currentIntervalLowerBound + change, this.currentIntervalUpperBound);
    }

    public void changeIntervalUpperBound(int change) {
        if (Screen.m_96638_()) {
            change *= 15;
        }
        this.currentIntervalUpperBound = change < 0 ? (byte)Math.max(this.currentIntervalUpperBound + change, this.currentIntervalLowerBound) : (byte)Math.min(this.currentIntervalUpperBound + change, 15);
    }

    public void changeIntervalOutput(int change) {
        if (Screen.m_96638_()) {
            change *= 15;
        }
        this.currentIntervalOutput = change < 0 ? (byte)Math.max(this.currentIntervalOutput + change, 0) : (byte)Math.min(this.currentIntervalOutput + change, 15);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        guiGraphics.m_280218_(GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void saveSettings() {
        PacketHandler.sendToServer(new PacketUpdateRedstoneCard(this.currentMode, this.currentRedstoneChannel, this.currentInterval, this.currentIntervalLowerBound, this.currentIntervalUpperBound, this.currentIntervalOutput, this.currentStrong, this.currentOutputMode, this.currentLogicOperation, this.currentLogicOperationChannel));
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public void setIntervalLowerBound(NumberButton button, int btn) {
        if (btn == 0) {
            this.changeIntervalLowerBound(1);
        } else if (btn == 1) {
            this.changeIntervalLowerBound(-1);
        }
        button.setValue(this.currentIntervalLowerBound);
        button.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void setIntervalUpperBound(NumberButton button, int btn) {
        if (btn == 0) {
            this.changeIntervalUpperBound(1);
        } else if (btn == 1) {
            this.changeIntervalUpperBound(-1);
        }
        button.setValue(this.currentIntervalUpperBound);
        button.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void setIntervalOutput(NumberButton button, int btn) {
        if (btn == 0) {
            this.changeIntervalOutput(1);
        } else if (btn == 1) {
            this.changeIntervalOutput(-1);
        }
        button.setValue(this.currentIntervalOutput);
        button.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = CardRedstone.previousRedstoneChannel(this.card);
            }
            channelButton.setChannel(this.currentRedstoneChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        NumberButton intervalLowerBoundButton = (NumberButton)this.buttons.get("intervalLowerBound");
        if (this.currentMode == 0 && this.currentInterval && MiscTools.inBounds(intervalLowerBoundButton.m_252754_(), intervalLowerBoundButton.m_252907_(), intervalLowerBoundButton.m_5711_(), intervalLowerBoundButton.m_93694_(), x, y)) {
            this.setIntervalLowerBound(intervalLowerBoundButton, btn);
            return true;
        }
        NumberButton intervalUpperBoundButton = (NumberButton)this.buttons.get("intervalUpperBound");
        if (this.currentMode == 0 && this.currentInterval && MiscTools.inBounds(intervalUpperBoundButton.m_252754_(), intervalUpperBoundButton.m_252907_(), intervalUpperBoundButton.m_5711_(), intervalUpperBoundButton.m_93694_(), x, y)) {
            this.setIntervalUpperBound(intervalUpperBoundButton, btn);
            return true;
        }
        NumberButton intervalOutputButton = (NumberButton)this.buttons.get("intervalOutput");
        if (this.currentMode == 0 && this.currentInterval && MiscTools.inBounds(intervalOutputButton.m_252754_(), intervalOutputButton.m_252907_(), intervalOutputButton.m_5711_(), intervalOutputButton.m_93694_(), x, y)) {
            this.setIntervalOutput(intervalOutputButton, btn);
            return true;
        }
        ChannelButton logicOperationChannelButton = (ChannelButton)this.buttons.get("logicOperationChannel");
        if (this.currentMode == 1 && this.currentLogicOperation != 0 && MiscTools.inBounds(logicOperationChannelButton.m_252754_(), logicOperationChannelButton.m_252907_(), logicOperationChannelButton.m_5711_(), logicOperationChannelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentLogicOperationChannel = CardRedstone.nextRedstoneChannelOperation(this.card);
            } else if (btn == 1) {
                this.currentLogicOperationChannel = CardRedstone.previousRedstoneChannelOperation(this.card);
            }
            logicOperationChannelButton.setChannel(this.currentLogicOperationChannel);
            logicOperationChannelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

