/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.renderer;

import com.direwolf20.laserio.client.events.ClientEvents;
import com.direwolf20.laserio.client.renderer.MyRenderType;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.CardRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderUtils {
    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float scale) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.5f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static Vector3f calculateEndAdvConnector(BlockPos startBlock, BlockPos endBlock, Direction facing) {
        float diffX = endBlock.m_123341_() - startBlock.m_123341_();
        float diffY = endBlock.m_123342_() - startBlock.m_123342_();
        float diffZ = endBlock.m_123343_() - startBlock.m_123343_();
        switch (facing) {
            case UP: {
                diffX += 0.5f;
                diffY -= 0.25f;
                diffZ += 0.5f;
                break;
            }
            case DOWN: {
                diffX += 0.5f;
                diffY += 1.25f;
                diffZ += 0.5f;
                break;
            }
            case NORTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ += 1.25f;
                break;
            }
            case SOUTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ -= 0.25f;
                break;
            }
            case EAST: {
                diffX -= 0.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
                break;
            }
            case WEST: {
                diffX += 1.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
            }
        }
        return new Vector3f(diffX, diffY, diffZ);
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockEntity be) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vector3f P = new Vector3f((float)player.m_20185_() - (float)be.m_58899_().m_123341_(), (float)player.m_20188_() - (float)be.m_58899_().m_123342_(), (float)player.m_20189_() - (float)be.m_58899_().m_123343_());
        Vector3f PS = new Vector3f((Vector3fc)from);
        PS.sub((Vector3fc)P);
        Vector3f SE = new Vector3f((Vector3fc)to);
        SE.sub((Vector3fc)from);
        Vector3f adjustedVec = new Vector3f((Vector3fc)PS);
        adjustedVec.cross((Vector3fc)SE);
        adjustedVec.normalize();
        return adjustedVec;
    }

    public static void addVertexToBuilder(VertexConsumer builder, Matrix4f positionMatrix, Vector3f position, float r, float g, float b, float alpha, float v1, float v2) {
        builder.m_252986_(positionMatrix, position.x(), position.y(), position.z()).m_85950_(r, g, b, alpha).m_7421_(v1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
    }

    public static void drawLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, double v1, double v2, BlockEntity be) {
        Vector3f adjustedVec = RenderUtils.adjustBeamToEyes(from, to, be);
        adjustedVec.mul(thickness);
        Vector3f p1 = new Vector3f((Vector3fc)from);
        p1.add((Vector3fc)adjustedVec);
        Vector3f p2 = new Vector3f((Vector3fc)from);
        p2.sub((Vector3fc)adjustedVec);
        Vector3f p3 = new Vector3f((Vector3fc)to);
        p3.add((Vector3fc)adjustedVec);
        Vector3f p4 = new Vector3f((Vector3fc)to);
        p4.sub((Vector3fc)adjustedVec);
        RenderUtils.addVertexToBuilder(builder, positionMatrix, p1, r, g, b, alpha, 1.0f, (float)v1);
        RenderUtils.addVertexToBuilder(builder, positionMatrix, p3, r, g, b, alpha, 1.0f, (float)v2);
        RenderUtils.addVertexToBuilder(builder, positionMatrix, p4, r, g, b, alpha, 0.0f, (float)v2);
        RenderUtils.addVertexToBuilder(builder, positionMatrix, p2, r, g, b, alpha, 0.0f, (float)v1);
    }

    public static void drawLasers(Queue<BaseLaserBE> beRenders, PoseStack matrixStackIn) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        VertexConsumer builder = buffer.m_6299_(MyRenderType.CONNECTING_LASER);
        while (beRenders.size() > 0) {
            LaserConnectorAdvBE laserConnectorAdvBE;
            int alpha;
            ItemStack wrench;
            LocalPlayer player;
            Color color;
            BlockPos endBlock;
            BaseLaserBE be = beRenders.remove();
            Level level = be.m_58904_();
            long gameTime = level.m_46467_();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
            for (BlockPos target : be.getRenderedConnections()) {
                endBlock = be.getWorldPos(target);
                color = be.getColor();
                player = Minecraft.m_91087_().f_91074_;
                wrench = ClientEvents.findWrench((Player)player);
                alpha = wrench.m_41619_() ? color.getAlpha() : Math.min(color.getAlpha() + be.getWrenchAlpha(), 255);
                float diffX = (float)endBlock.m_123341_() + 0.5f - (float)startBlock.m_123341_();
                float diffY = (float)endBlock.m_123342_() + 0.5f - (float)startBlock.m_123342_();
                float diffZ = (float)endBlock.m_123343_() + 0.5f - (float)startBlock.m_123343_();
                Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)diffY * 1.5, be);
            }
            if (be instanceof LaserConnectorAdvBE && (laserConnectorAdvBE = (LaserConnectorAdvBE)be).getPartnerDimBlockPos() != null && level.m_8055_(be.m_58899_()).m_60734_().equals(Registration.LASER_CONNECTOR_ADV_BLOCK.get())) {
                Direction facing = ((Direction)level.m_8055_(be.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
                endBlock = laserConnectorAdvBE.m_58899_().m_121945_(facing);
                color = be.getColor();
                player = Minecraft.m_91087_().f_91074_;
                wrench = ClientEvents.findWrench((Player)player);
                alpha = wrench.m_41619_() ? color.getAlpha() : Math.min(color.getAlpha() + be.getWrenchAlpha(), 255);
                Vector3f endLaser = RenderUtils.calculateEndAdvConnector(startBlock, endBlock, facing);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)endLaser.y() * 1.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.CONNECTING_LASER);
    }

    public static void drawConnectingLasersMainBeam(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn, MultiBufferSource.BufferSource buffer, Vec3 projectedView, float alpha, float thickness) {
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            Level level = be.m_58904_();
            long gameTime = level.m_46467_();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.r, cardRender.g, cardRender.b, alpha, thickness, v, v + (double)cardRender.diffY * 4.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_BEAM);
    }

    public static void drawConnectingLasersMainCore(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn, MultiBufferSource.BufferSource buffer, Vec3 projectedView, float alpha, float thickness) {
        VertexConsumer builder = buffer.m_6299_(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            Level level = be.m_58904_();
            long gameTime = level.m_46467_();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.m_58899_();
            matrixStackIn.m_85836_();
            Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
            matrixStackIn.m_85837_((double)startBlock.m_123341_() - projectedView.f_82479_, (double)startBlock.m_123342_() - projectedView.f_82480_, (double)startBlock.m_123343_() - projectedView.f_82481_);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.floatColors[0], cardRender.floatColors[1], cardRender.floatColors[2], 1.0f, 0.0125f, v, v + (double)cardRender.diffY * 1.5, be);
            }
            matrixStackIn.m_85849_();
        }
        buffer.m_109912_(MyRenderType.LASER_MAIN_CORE);
    }

    public static void drawConnectingLasers(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float alpha = 1.0f;
        float thickness = 0.0175f;
        if (ClientEvents.IS_OCULUS_LOADED) {
            RenderUtils.drawConnectingLasersMainCore(beConnectingRenders, matrixStackIn, buffer, projectedView, alpha, thickness);
            RenderUtils.drawConnectingLasersMainBeam(beConnectingRenders, matrixStackIn, buffer, projectedView, alpha, thickness);
        } else {
            RenderUtils.drawConnectingLasersMainBeam(beConnectingRenders, matrixStackIn, buffer, projectedView, alpha, thickness);
            RenderUtils.drawConnectingLasersMainCore(beConnectingRenders, matrixStackIn, buffer, projectedView, alpha, thickness);
        }
    }
}

